/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.resource.factory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.FieldMetadata;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ResourceDefinition;
import cn.stylefeng.roses.kernel.system.modular.resource.entity.SysResource;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourceFactory {
    public static SysResource createResource(ResourceDefinition resourceDefinition) {
        SysResource resource = new SysResource();
        BeanUtil.copyProperties((Object)resourceDefinition, (Object)((Object)resource), (CopyOptions)CopyOptions.create().ignoreError());
        resource.setResourceCode(resourceDefinition.getResourceCode());
        if (resourceDefinition.getRequiredLoginFlag().booleanValue()) {
            resource.setRequiredLoginFlag(YesOrNotEnum.Y.name());
        } else {
            resource.setRequiredLoginFlag(YesOrNotEnum.N.name());
        }
        if (resourceDefinition.getRequiredPermissionFlag().booleanValue()) {
            resource.setRequiredPermissionFlag(YesOrNotEnum.Y.name());
        } else {
            resource.setRequiredPermissionFlag(YesOrNotEnum.N.name());
        }
        if (resourceDefinition.getViewFlag().booleanValue()) {
            resource.setViewFlag(YesOrNotEnum.Y.name());
        } else {
            resource.setViewFlag(YesOrNotEnum.N.name());
        }
        if (ObjectUtil.isNotEmpty((Object)resourceDefinition.getValidateGroups())) {
            resource.setValidateGroups(JSON.toJSONString((Object)resourceDefinition.getValidateGroups(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
        }
        if (ObjectUtil.isNotEmpty((Object)resourceDefinition.getParamFieldDescriptions())) {
            resource.setParamFieldDescriptions(JSON.toJSONString((Object)resourceDefinition.getParamFieldDescriptions(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
        }
        if (ObjectUtil.isNotEmpty((Object)resourceDefinition.getResponseFieldDescriptions())) {
            resource.setResponseFieldDescriptions(JSON.toJSONString((Object)resourceDefinition.getResponseFieldDescriptions(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
        }
        return resource;
    }

    public static ResourceDefinition createResourceDefinition(SysResource sysResource) {
        ResourceDefinition resourceDefinition = new ResourceDefinition();
        BeanUtil.copyProperties((Object)((Object)sysResource), (Object)resourceDefinition, (CopyOptions)CopyOptions.create().ignoreError());
        resourceDefinition.setRequiredLoginFlag(Boolean.valueOf(YesOrNotEnum.Y.name().equals(sysResource.getRequiredLoginFlag())));
        resourceDefinition.setRequiredPermissionFlag(Boolean.valueOf(YesOrNotEnum.Y.name().equals(sysResource.getRequiredPermissionFlag())));
        resourceDefinition.setViewFlag(Boolean.valueOf(YesOrNotEnum.Y.name().equals(sysResource.getViewFlag())));
        if (ObjectUtil.isNotEmpty((Object)sysResource.getValidateGroups())) {
            resourceDefinition.setValidateGroups((Set)JSON.parseObject((String)sysResource.getValidateGroups(), Set.class, (Feature[])new Feature[]{Feature.SupportAutoType}));
        }
        if (ObjectUtil.isNotEmpty((Object)sysResource.getParamFieldDescriptions())) {
            resourceDefinition.setParamFieldDescriptions((Set)JSON.parseObject((String)sysResource.getParamFieldDescriptions(), Set.class, (Feature[])new Feature[]{Feature.SupportAutoType}));
        }
        if (ObjectUtil.isNotEmpty((Object)sysResource.getResponseFieldDescriptions())) {
            resourceDefinition.setResponseFieldDescriptions((FieldMetadata)JSON.parseObject((String)sysResource.getResponseFieldDescriptions(), FieldMetadata.class, (Feature[])new Feature[]{Feature.SupportAutoType}));
        }
        return resourceDefinition;
    }

    public static ResourceDefinition fillResourceDetail(ResourceDefinition resourceDefinition) {
        Set validateGroups = resourceDefinition.getValidateGroups();
        Set paramFieldDescriptions = resourceDefinition.getParamFieldDescriptions();
        if (paramFieldDescriptions != null && paramFieldDescriptions.size() > 0) {
            for (FieldMetadata fieldMetadata : paramFieldDescriptions) {
                ResourceFactory.fillDetailMessage(validateGroups, fieldMetadata);
            }
        }
        FieldMetadata responseFieldDescriptions = resourceDefinition.getResponseFieldDescriptions();
        ResourceFactory.fillDetailMessage(validateGroups, responseFieldDescriptions);
        return resourceDefinition;
    }

    public static void fillDetailMessage(Set<String> validateGroups, FieldMetadata fieldMetadata) {
        if (validateGroups == null || validateGroups.isEmpty()) {
            return;
        }
        if (fieldMetadata == null) {
            return;
        }
        StringBuilder finalValidateMessages = new StringBuilder();
        Map groupAnnotations = fieldMetadata.getGroupValidationMessage();
        if (groupAnnotations != null) {
            for (String validateGroup : validateGroups) {
                Set validateMessage = (Set)groupAnnotations.get(validateGroup);
                if (validateMessage == null || validateMessage.isEmpty()) continue;
                finalValidateMessages.append(StrUtil.join((CharSequence)"\uff0c", (Iterable)validateMessage));
            }
        }
        fieldMetadata.setValidationMessages(finalValidateMessages.toString());
        if (fieldMetadata.getGenericFieldMetadata() != null && !fieldMetadata.getGenericFieldMetadata().isEmpty()) {
            for (FieldMetadata metadata : fieldMetadata.getGenericFieldMetadata()) {
                ResourceFactory.fillDetailMessage(validateGroups, metadata);
            }
        }
    }

    public static Map<String, ResourceDefinition> orderedResourceDefinition(List<ResourceDefinition> sysResourceList) {
        HashMap<String, ResourceDefinition> result = new HashMap<String, ResourceDefinition>();
        if (ObjectUtil.isEmpty(sysResourceList)) {
            return result;
        }
        for (ResourceDefinition sysResource : sysResourceList) {
            String url = sysResource.getUrl();
            result.put(url, sysResource);
        }
        return result;
    }
}

