/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.wrapper.field.jackson;

import cn.stylefeng.roses.kernel.rule.annotation.EnumFieldFormat;
import cn.stylefeng.roses.kernel.rule.annotation.SimpleFieldFormat;
import cn.stylefeng.roses.kernel.rule.enums.FormatTypeEnum;
import cn.stylefeng.roses.kernel.wrapper.field.enums.EnumFieldFormatDeserializer;
import cn.stylefeng.roses.kernel.wrapper.field.enums.EnumFieldFormatSerializer;
import cn.stylefeng.roses.kernel.wrapper.field.simple.SimpleFieldFormatSerializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;

public class CustomJacksonIntrospector
extends JacksonAnnotationIntrospector {
    private static final long serialVersionUID = 3159434791568421355L;

    public Object findSerializer(Annotated annotated) {
        SimpleFieldFormat simpleFieldFormat = (SimpleFieldFormat)annotated.getAnnotation(SimpleFieldFormat.class);
        if (simpleFieldFormat != null && simpleFieldFormat.processClass() != null) {
            FormatTypeEnum formatTypeEnum = simpleFieldFormat.formatType();
            Class process = simpleFieldFormat.processClass();
            return new SimpleFieldFormatSerializer(formatTypeEnum, process);
        }
        EnumFieldFormat enumFieldFormat = (EnumFieldFormat)annotated.getAnnotation(EnumFieldFormat.class);
        if (enumFieldFormat != null && enumFieldFormat.processEnum() != null) {
            FormatTypeEnum formatTypeEnum = enumFieldFormat.formatType();
            Class process = enumFieldFormat.processEnum();
            return new EnumFieldFormatSerializer(formatTypeEnum, process);
        }
        return super.findSerializer(annotated);
    }

    public Object findDeserializer(Annotated annotated) {
        EnumFieldFormat enumFieldFormat = (EnumFieldFormat)annotated.getAnnotation(EnumFieldFormat.class);
        if (enumFieldFormat != null && enumFieldFormat.processEnum() != null) {
            Class process = enumFieldFormat.processEnum();
            return new EnumFieldFormatDeserializer(process);
        }
        return super.findDeserializer(annotated);
    }
}

