/*
 * Decompiled with CFR 0.152.
 */
package com.office;

import com.office.builder.yml.OOConfigBuilder;
import com.office.cache.InsideCache;
import com.office.config.oo.OnlyProperties;
import com.office.config.wps.WPSBaseInfo;
import com.office.core.Cache;
import com.office.core.CommonConfig;
import com.office.core.SaveFileProcessor;
import com.office.office.oo.OnlyOfficeAPI;
import com.office.office.oo.handler.OOFileHandlerImpl;
import com.office.office.wps.WPSOfficeAPI;
import com.office.office.wps.handler.WPSFileHandlerImpl;
import com.office.tools.wps.SDKUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan
@ConfigurationProperties(prefix="office")
public class OfficeAutoConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(OfficeAutoConfiguration.class);
    private String type;
    private String dowloadFile;
    private String localhostAddress;
    private Integer histNum;
    private Integer timeout;
    private Long maxSize;
    private WPSBaseInfo wps = new WPSBaseInfo();
    private OnlyProperties oo = new OnlyProperties();
    private ApplicationContext applicationContext;

    @Bean
    public WPSOfficeAPI createWPSBean() {
        if ("wps".equals(this.type.toLowerCase())) {
            if (StringUtils.isEmpty((CharSequence)this.wps.getAk())) {
                throw new IllegalStateException("office.wps.ak is empty");
            }
            if (StringUtils.isEmpty((CharSequence)this.wps.getSk())) {
                throw new IllegalStateException("office.wps.sk is empty");
            }
            if (StringUtils.isEmpty((CharSequence)this.wps.getDomainName())) {
                throw new IllegalStateException("office.wps.domain_name is empty");
            }
            CommonConfig commonConfig = this.getCommonConfig();
            Cache insideCache = this.getCche();
            WPSOfficeAPI wpsOfficeAPI = new WPSOfficeAPI(commonConfig);
            wpsOfficeAPI.setCache(insideCache);
            wpsOfficeAPI.setWpsBaseInfo(this.wps);
            wpsOfficeAPI.setFileHandler(new WPSFileHandlerImpl(commonConfig, insideCache));
            wpsOfficeAPI.setSdkUtil(SDKUtil.create(this.wps.getDomainName(), this.wps.getAk(), this.wps.getSk()));
            log.info("wpsAPI \u521d\u59cb\u5316\u6210\u529f");
            return wpsOfficeAPI;
        }
        return null;
    }

    @Bean
    public OnlyOfficeAPI createOOBean() {
        if ("oo".equals(this.type.toLowerCase())) {
            if (StringUtils.isEmpty((CharSequence)this.oo.getDocService())) {
                throw new IllegalStateException("OnlyOffice\u670d\u52a1\u5730\u5740\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)this.oo.getCallBackUrl())) {
                throw new IllegalStateException("OnlyOffice\u670d\u52a1\u56de\u8c03\u5730\u5740\u4e3a\u7a7a");
            }
            SaveFileProcessor bean = (SaveFileProcessor)this.applicationContext.getBean(SaveFileProcessor.class);
            if (bean == null) {
                throw new NoClassDefFoundError(SaveFileProcessor.class.getName());
            }
            CommonConfig commonConfig = this.getCommonConfig();
            Cache insideCache = this.getCche();
            OnlyOfficeAPI onlyOfficeAPI = new OnlyOfficeAPI(commonConfig);
            onlyOfficeAPI.setCache(insideCache);
            onlyOfficeAPI.setOnlyProperties(this.oo);
            onlyOfficeAPI.setSaveFileProcessor(bean);
            onlyOfficeAPI.setFileHandler(new OOFileHandlerImpl(commonConfig, insideCache));
            OOConfigBuilder ooConfigBuilder = new OOConfigBuilder(onlyOfficeAPI, this.oo, commonConfig, "onlyOffice.yml");
            ooConfigBuilder.parse();
            log.info("OnlyOffice API \u521d\u59cb\u5316\u6210\u529f");
            return onlyOfficeAPI;
        }
        return null;
    }

    private CommonConfig getCommonConfig() {
        return new CommonConfig(this.dowloadFile, this.localhostAddress, this.histNum, this.timeout, this.maxSize);
    }

    private Cache getCche() {
        return new InsideCache();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getType() {
        return this.type;
    }

    public String getDowloadFile() {
        return this.dowloadFile;
    }

    public String getLocalhostAddress() {
        return this.localhostAddress;
    }

    public Integer getHistNum() {
        return this.histNum;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public WPSBaseInfo getWps() {
        return this.wps;
    }

    public OnlyProperties getOo() {
        return this.oo;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDowloadFile(String dowloadFile) {
        this.dowloadFile = dowloadFile;
    }

    public void setLocalhostAddress(String localhostAddress) {
        this.localhostAddress = localhostAddress;
    }

    public void setHistNum(Integer histNum) {
        this.histNum = histNum;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }

    public void setWps(WPSBaseInfo wps) {
        this.wps = wps;
    }

    public void setOo(OnlyProperties oo) {
        this.oo = oo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OfficeAutoConfiguration)) {
            return false;
        }
        OfficeAutoConfiguration other = (OfficeAutoConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$histNum = this.getHistNum();
        Integer other$histNum = other.getHistNum();
        if (this$histNum == null ? other$histNum != null : !((Object)this$histNum).equals(other$histNum)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Long this$maxSize = this.getMaxSize();
        Long other$maxSize = other.getMaxSize();
        if (this$maxSize == null ? other$maxSize != null : !((Object)this$maxSize).equals(other$maxSize)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$dowloadFile = this.getDowloadFile();
        String other$dowloadFile = other.getDowloadFile();
        if (this$dowloadFile == null ? other$dowloadFile != null : !this$dowloadFile.equals(other$dowloadFile)) {
            return false;
        }
        String this$localhostAddress = this.getLocalhostAddress();
        String other$localhostAddress = other.getLocalhostAddress();
        if (this$localhostAddress == null ? other$localhostAddress != null : !this$localhostAddress.equals(other$localhostAddress)) {
            return false;
        }
        WPSBaseInfo this$wps = this.getWps();
        WPSBaseInfo other$wps = other.getWps();
        if (this$wps == null ? other$wps != null : !((Object)this$wps).equals(other$wps)) {
            return false;
        }
        OnlyProperties this$oo = this.getOo();
        OnlyProperties other$oo = other.getOo();
        if (this$oo == null ? other$oo != null : !((Object)this$oo).equals(other$oo)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        return !(this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OfficeAutoConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $histNum = this.getHistNum();
        result = result * 59 + ($histNum == null ? 43 : ((Object)$histNum).hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Long $maxSize = this.getMaxSize();
        result = result * 59 + ($maxSize == null ? 43 : ((Object)$maxSize).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $dowloadFile = this.getDowloadFile();
        result = result * 59 + ($dowloadFile == null ? 43 : $dowloadFile.hashCode());
        String $localhostAddress = this.getLocalhostAddress();
        result = result * 59 + ($localhostAddress == null ? 43 : $localhostAddress.hashCode());
        WPSBaseInfo $wps = this.getWps();
        result = result * 59 + ($wps == null ? 43 : ((Object)$wps).hashCode());
        OnlyProperties $oo = this.getOo();
        result = result * 59 + ($oo == null ? 43 : ((Object)$oo).hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        return result;
    }

    public String toString() {
        return "OfficeAutoConfiguration(type=" + this.getType() + ", dowloadFile=" + this.getDowloadFile() + ", localhostAddress=" + this.getLocalhostAddress() + ", histNum=" + this.getHistNum() + ", timeout=" + this.getTimeout() + ", maxSize=" + this.getMaxSize() + ", wps=" + this.getWps() + ", oo=" + this.getOo() + ", applicationContext=" + this.getApplicationContext() + ")";
    }
}

