/*
 * Decompiled with CFR 0.152.
 */
package com.office.builder.yml;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.office.config.oo.OnlyProperties;
import com.office.config.oo.Plugins;
import com.office.config.oo.document.DocumentPermission;
import com.office.config.oo.edit.FileCustomization;
import com.office.config.oo.edit.FileEmbedded;
import com.office.core.CommonConfig;
import com.office.office.oo.OnlyOfficeAPI;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class OOConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(OOConfigBuilder.class);
    private String resource;
    private JSONObject configData;
    private OnlyOfficeAPI onlyOfficeAPI;
    private OnlyProperties onlyProperties;
    private CommonConfig configuration;

    public OOConfigBuilder(OnlyOfficeAPI onlyOfficeAPI, OnlyProperties onlyProperties, CommonConfig configuration, String name) {
        this.onlyOfficeAPI = onlyOfficeAPI;
        this.onlyProperties = onlyProperties;
        this.configuration = configuration;
        log.info("--------\u52a0\u8f7d\u3010office.yml\u3011\u914d\u7f6e\u6587\u4ef6-------");
        Yaml yaml = new Yaml();
        try {
            this.resource = name;
            InputStream inputStream = OOConfigBuilder.class.getClassLoader().getResourceAsStream(name);
            this.configData = ((JSONObject)yaml.loadAs(inputStream, JSONObject.class)).getJSONObject((Object)"oo");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parse() {
        this.setDocument();
        this.setEditor();
        this.onlyOfficeAPI.setConvert(this.configData.getJSONObject((Object)"convert"));
        log.info("--------\u3010office.yml\u3011\u52a0\u8f7d\u5b8c\u6210-------");
    }

    private void setDocument() {
        JSONObject document = this.configData.getJSONObject((Object)"document");
        if (null != document || null != document.getJSONObject((Object)"permissions")) {
            JSONObject permissions = document.getJSONObject((Object)"permissions");
            if (null != permissions.getJSONObject((Object)"edit")) {
                DocumentPermission editPermission = (DocumentPermission)JSONUtil.toBean((String)permissions.getJSONObject((Object)"edit").toString(), DocumentPermission.class);
                editPermission.setEdit(true);
                this.onlyOfficeAPI.setEditPermission(editPermission);
            }
            if (null != permissions.getJSONObject((Object)"view")) {
                DocumentPermission viewPermission = (DocumentPermission)JSONUtil.toBean((String)permissions.getJSONObject((Object)"view").toString(), DocumentPermission.class);
                viewPermission.setEdit(false);
                this.onlyOfficeAPI.setViewPermission(viewPermission);
            }
        }
    }

    private void setEditor() {
        JSONObject editor = this.configData.getJSONObject((Object)"editor");
        if (null != editor) {
            FileCustomization customization = (FileCustomization)JSONUtil.toBean((String)editor.getJSONObject((Object)"customization").toString(), FileCustomization.class);
            this.onlyOfficeAPI.setCustomization(customization);
        }
        this.setEmbedded(editor);
        this.setPlugins(editor);
    }

    private void setEmbedded(JSONObject editor) {
        JSONObject embeddedJson = editor.getJSONObject((Object)"embedded");
        if (null != embeddedJson) {
            FileEmbedded embedded = (FileEmbedded)JSONUtil.toBean((String)embeddedJson.toString(), FileEmbedded.class);
            this.onlyOfficeAPI.setEmbedded(embedded);
        }
    }

    private void setPlugins(JSONObject editor) {
        JSONObject pluginsJson = editor.getJSONObject((Object)"plugins");
        if (null != pluginsJson) {
            Plugins plugins = (Plugins)JSONUtil.toBean((String)pluginsJson.toString(), Plugins.class);
            this.onlyOfficeAPI.setPlugins(plugins);
        }
    }
}

