/*
 * Decompiled with CFR 0.152.
 */
package com.office.cache;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import com.office.core.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsideCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(InsideCache.class);
    private long timeUnit = 1000L;
    private TimedCache<String, Object> cache = CacheUtil.newTimedCache((long)60000L);

    public InsideCache() {
        this.cache.schedulePrune(60000L);
    }

    @Override
    public Object get(String key) {
        return this.cache.get((Object)key);
    }

    @Override
    public boolean hasKey(String key) {
        return this.cache.get((Object)key) != null;
    }

    @Override
    public void set(String key, Object value, long time) {
        if (time < this.timeUnit) {
            time = 60000L;
        }
        this.cache.put((Object)key, value, time * this.timeUnit);
        log.info("key:{},value:{},size:{}", new Object[]{key, value, this.cache.size()});
    }

    @Override
    public void set(String key, Object value) {
        this.cache.put((Object)key, value);
        log.info("key:{},value:{},size:{}", new Object[]{key, value, this.cache.size()});
    }

    @Override
    public void remove(String key) {
        this.cache.remove((Object)key);
    }
}

