/*
 * Decompiled with CFR 0.152.
 */
package com.office.config;

import cn.hutool.core.date.DateUtil;
import com.office.config.oo.DocumentConfig;
import com.office.config.oo.EditorConfig;
import com.office.config.oo.FileConfig;
import com.office.config.oo.OnlyProperties;
import com.office.config.oo.Plugins;
import com.office.config.oo.document.DocumentInfo;
import com.office.config.oo.document.DocumentPermission;
import com.office.config.oo.document.SharingSettings;
import com.office.config.oo.edit.FileCustomization;
import com.office.config.oo.edit.FileUser;
import com.office.config.wps.FileInfo;
import com.office.config.wps.FileWatermark;
import com.office.config.wps.UserAcl;
import com.office.config.wps.UserInfo;
import com.office.exception.OfficeException;
import com.office.tools.FileUtil;
import com.office.tools.oo.JWTUtil;
import com.office.tools.oo.OnlyOfficeUtil;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuilderConfigInfo {
    protected static final Logger logger = LoggerFactory.getLogger(BuilderConfigInfo.class);

    public static Map<String, Object> builderWpsConfig(FileInfo fileInfo, UserAcl userAcl, FileWatermark watermark, UserInfo userInfo) {
        if (null == fileInfo || null == userInfo) {
            throw new OfficeException("\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570");
        }
        fileInfo.setUser_acl(userAcl);
        fileInfo.setWatermark(watermark);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("file", fileInfo);
        config.put("user", userInfo);
        return config;
    }

    public static FileConfig buildOnlyConfig(String fileUrl, String mode, String key, String fileName, String callBackUrl, OnlyProperties onlyProperties, FileUser user, Plugins plugins, DocumentPermission permission, FileCustomization customPermissions) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FileConfig fileConfigDTO = new FileConfig();
        fileConfigDTO.setDocumentType(OnlyOfficeUtil.getDocumentType(fileName));
        map.put("documentType", fileConfigDTO.getDocumentType());
        map.put("type", fileConfigDTO.getType());
        fileConfigDTO.setDocServiceApiUrl(onlyProperties.getDocService() + onlyProperties.getDOC_API_URL());
        String typePart = FileUtil.getFileExtension(fileName);
        DocumentConfig fileDocument = DocumentConfig.builder().title(fileName).fileType(typePart).url(fileUrl).key(key).info(BuilderConfigInfo.getDocumentInfo(user)).permissions(permission).build();
        fileConfigDTO.setDocument(fileDocument);
        map.put("document", fileDocument);
        EditorConfig editorConfig = new EditorConfig(callBackUrl, mode);
        editorConfig.setFileCustomization(customPermissions);
        editorConfig.setFileUser(user);
        editorConfig.setPlugins(plugins);
        fileConfigDTO.setEditorConfig(editorConfig);
        map.put("editorConfig", editorConfig);
        if (null != onlyProperties.getSecret()) {
            String token = JWTUtil.createToken(map, onlyProperties.getSecret());
            fileConfigDTO.setToken(token);
        }
        return fileConfigDTO;
    }

    private static DocumentInfo getDocumentInfo(FileUser user) {
        SharingSettings sharingSettings = new SharingSettings();
        sharingSettings.setPermissions(new String[]{"Full Access"});
        sharingSettings.setUser(user.getName());
        sharingSettings.setIsLink(true);
        DocumentInfo info = DocumentInfo.builder().created(DateUtil.formatDateTime((Date)new Date())).sharingSettings(Collections.singletonList(sharingSettings)).build();
        return info;
    }
}

