/*
 * Decompiled with CFR 0.152.
 */
package com.office.office.wps;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.office.config.BuilderConfigInfo;
import com.office.config.wps.FileInfo;
import com.office.config.wps.FileWatermark;
import com.office.config.wps.UserAcl;
import com.office.config.wps.UserInfo;
import com.office.config.wps.WPSBaseInfo;
import com.office.core.Cache;
import com.office.core.CommonConfig;
import com.office.core.FileHandler;
import com.office.core.context.FileMetadata;
import com.office.tools.OfficeResult;
import com.office.tools.wps.PreviewMode;
import com.office.tools.wps.SDKUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWPSOfficeBase {
    private static final Logger log = LoggerFactory.getLogger(AbstractWPSOfficeBase.class);
    protected final CommonConfig configuration;
    private Cache cache;
    private FileHandler fileHandler;
    private WPSBaseInfo wpsBaseInfo;
    protected SDKUtil sdkUtil;
    protected String EDIT = "edit";
    protected String VIEW = "view";

    public AbstractWPSOfficeBase(CommonConfig configuration) {
        this.configuration = configuration;
    }

    public void setCache(String key, String value) {
        this.cache.set(key, value);
    }

    public Integer getHistNum() {
        return this.configuration.getHistNum();
    }

    public FileMetadata getTempFile(String key) {
        FileMetadata tempFileInfo = this.fileHandler.getTempFile(key);
        if (tempFileInfo != null) {
            return tempFileInfo;
        }
        return null;
    }

    public void removeTempFile(JSONObject jsonObject) {
        String key = (String)jsonObject.get((Object)"key");
        FileMetadata tempFileInfo = this.fileHandler.getTempFile(key);
        if (tempFileInfo != null) {
            log.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u4fe1\u606f\u7f13\u5b58" + key);
            this.fileHandler.removeTempFile(key);
        }
    }

    public String openDocument(String fileId, String fileName, Integer _w_tokentype, Map<String, String> params) {
        OfficeResult editURl = this.sdkUtil.getEditURl(fileId, fileName, _w_tokentype, params);
        String data = (String)editURl.getData();
        JSONObject jsonObject = (JSONObject)JSONUtil.toBean((String)data, JSONObject.class);
        return jsonObject.getStr((Object)"link");
    }

    public String openDocument(String fileId, String fileName, PreviewMode previewMode, Integer _w_tokentype, String wpsPreview, Map<String, String> params) {
        OfficeResult previewURl = this.sdkUtil.getPreviewURl(fileId, fileName, previewMode, wpsPreview, _w_tokentype, params);
        String data = (String)previewURl.getData();
        JSONObject jsonObject = (JSONObject)JSONUtil.toBean((String)data, JSONObject.class);
        return jsonObject.getStr((Object)"link");
    }

    public Map<String, Object> generateConfig(Map<String, Object> fileMeta, FileInfo fileInfo, UserAcl userAcl, FileWatermark watermark, UserInfo userInfo) {
        try {
            log.info("\u5f00\u59cb\u751f\u6210\u6587\u4ef6\u4fe1\u606f");
            FileMetadata tempFileInfo = this.fileHandler.handlerFile(fileMeta, null);
            log.info("\u5f00\u59cb\u751f\u6210\u7f16\u8f91\u5668\u914d\u7f6e\u4fe1\u606f");
            fileInfo.setDownload_url(tempFileInfo.getUrl());
            Map<String, Object> config = BuilderConfigInfo.builderWpsConfig(fileInfo, userAcl, watermark, userInfo);
            log.info("\u751f\u6210\u7f16\u8f91\u5668\u914d\u7f6e\u4fe1\u606f\u7ed3\u675f");
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CommonConfig getConfiguration() {
        return this.configuration;
    }

    public Cache getCache() {
        return this.cache;
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public WPSBaseInfo getWpsBaseInfo() {
        return this.wpsBaseInfo;
    }

    public SDKUtil getSdkUtil() {
        return this.sdkUtil;
    }

    public String getEDIT() {
        return this.EDIT;
    }

    public String getVIEW() {
        return this.VIEW;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public void setWpsBaseInfo(WPSBaseInfo wpsBaseInfo) {
        this.wpsBaseInfo = wpsBaseInfo;
    }

    public void setSdkUtil(SDKUtil sdkUtil) {
        this.sdkUtil = sdkUtil;
    }

    public void setEDIT(String EDIT) {
        this.EDIT = EDIT;
    }

    public void setVIEW(String VIEW) {
        this.VIEW = VIEW;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractWPSOfficeBase)) {
            return false;
        }
        AbstractWPSOfficeBase other = (AbstractWPSOfficeBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommonConfig this$configuration = this.getConfiguration();
        CommonConfig other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Cache this$cache = this.getCache();
        Cache other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !this$cache.equals(other$cache)) {
            return false;
        }
        FileHandler this$fileHandler = this.getFileHandler();
        FileHandler other$fileHandler = other.getFileHandler();
        if (this$fileHandler == null ? other$fileHandler != null : !this$fileHandler.equals(other$fileHandler)) {
            return false;
        }
        WPSBaseInfo this$wpsBaseInfo = this.getWpsBaseInfo();
        WPSBaseInfo other$wpsBaseInfo = other.getWpsBaseInfo();
        if (this$wpsBaseInfo == null ? other$wpsBaseInfo != null : !((Object)this$wpsBaseInfo).equals(other$wpsBaseInfo)) {
            return false;
        }
        SDKUtil this$sdkUtil = this.getSdkUtil();
        SDKUtil other$sdkUtil = other.getSdkUtil();
        if (this$sdkUtil == null ? other$sdkUtil != null : !this$sdkUtil.equals(other$sdkUtil)) {
            return false;
        }
        String this$EDIT = this.getEDIT();
        String other$EDIT = other.getEDIT();
        if (this$EDIT == null ? other$EDIT != null : !this$EDIT.equals(other$EDIT)) {
            return false;
        }
        String this$VIEW = this.getVIEW();
        String other$VIEW = other.getVIEW();
        return !(this$VIEW == null ? other$VIEW != null : !this$VIEW.equals(other$VIEW));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractWPSOfficeBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommonConfig $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Cache $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : $cache.hashCode());
        FileHandler $fileHandler = this.getFileHandler();
        result = result * 59 + ($fileHandler == null ? 43 : $fileHandler.hashCode());
        WPSBaseInfo $wpsBaseInfo = this.getWpsBaseInfo();
        result = result * 59 + ($wpsBaseInfo == null ? 43 : ((Object)$wpsBaseInfo).hashCode());
        SDKUtil $sdkUtil = this.getSdkUtil();
        result = result * 59 + ($sdkUtil == null ? 43 : $sdkUtil.hashCode());
        String $EDIT = this.getEDIT();
        result = result * 59 + ($EDIT == null ? 43 : $EDIT.hashCode());
        String $VIEW = this.getVIEW();
        result = result * 59 + ($VIEW == null ? 43 : $VIEW.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractWPSOfficeBase(configuration=" + this.getConfiguration() + ", cache=" + this.getCache() + ", fileHandler=" + this.getFileHandler() + ", wpsBaseInfo=" + this.getWpsBaseInfo() + ", sdkUtil=" + this.getSdkUtil() + ", EDIT=" + this.getEDIT() + ", VIEW=" + this.getVIEW() + ")";
    }
}

