/*
 * Decompiled with CFR 0.152.
 */
package com.office.tools.oo;

import com.office.tools.FileUtil;
import com.office.tools.oo.DocumentTypeEnum;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlyOfficeUtil {
    private static final Logger log = LoggerFactory.getLogger(OnlyOfficeUtil.class);
    private static List<String> ExtsDocument = Arrays.asList(".doc", ".docx", ".docm", ".dot", ".dotx", ".dotm", ".odt", ".fodt", ".ott", ".rtf", ".txt", ".html", ".htm", ".mht", ".pdf", ".djvu", ".fb2", ".epub", ".xps");
    private static List<String> ExtsSpreadsheet = Arrays.asList(".xls", ".xlsx", ".xlsm", ".xlt", ".xltx", ".xltm", ".ods", ".fods", ".ots", ".csv");
    private static List<String> ExtsPresentation = Arrays.asList(".pps", ".ppsx", ".ppsm", ".ppt", ".pptx", ".pptm", ".pot", ".potx", ".potm", ".odp", ".fodp", ".otp");

    public static String getDocumentType(String fileName) {
        String ext = "." + FileUtil.getFileExtension(fileName);
        if (ExtsDocument.contains(ext)) {
            return DocumentTypeEnum.Word.toString().toLowerCase();
        }
        if (ExtsSpreadsheet.contains(ext)) {
            return DocumentTypeEnum.Cell.toString().toLowerCase();
        }
        if (ExtsPresentation.contains(ext)) {
            return DocumentTypeEnum.Slide.toString().toLowerCase();
        }
        return DocumentTypeEnum.Word.toString().toLowerCase();
    }
}

