/*
 * Decompiled with CFR 0.152.
 */
package com.office.tools.wps;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.office.config.wps.ConvertInfo;
import com.office.tools.OfficeResult;
import com.office.tools.wps.PreviewMode;
import com.office.tools.wps.WPS4Signature;
import com.office.tools.wps.WPSFileTypeUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDKUtil {
    private Logger logger = LoggerFactory.getLogger(SDKUtil.class);
    private final String PREFIX = "_w_third_";
    private final String CONTENT_TYPE = "application/json";
    private static SDKUtil sdkUtil = null;
    private String DOMAIN_NAME;
    private String AK;
    private String SK;
    private final String EDITAPI = "/api/edit/v1/files/${file_id}/link";
    private final String PREVIEWAPI = "/api/preview/v1/files/{file_id}/link";
    private final String PREVIEWAPI_P = "/api/preview/v2/files/{file_id}/versions/{version_id}/preload";
    private final String CONVERTAPI_SYNC = "/api/cps/sync/v1/convert";
    private final String CONVERTAPI_ASYNC = "/api/cps/async/v1/convert";
    private final String DOWNLOAD = "/api/cps/v1/download/";

    private SDKUtil() {
    }

    private SDKUtil(String domainName, String ak, String sk) {
        this.DOMAIN_NAME = domainName;
        this.AK = ak;
        this.SK = sk;
    }

    public static SDKUtil create(String domainName, String ak, String sk) {
        if (sdkUtil == null) {
            sdkUtil = new SDKUtil(domainName, ak, sk);
        }
        return sdkUtil;
    }

    public byte[] fileDownload(String download_id, String route_key) {
        WPS4Signature signature = new WPS4Signature(this.AK, this.SK);
        Map<String, String> headers = signature.getSignatureHeaders("GET", "/api/cps/v1/download/" + download_id, "", new Date(), "application/json");
        headers.put("Route-Key", route_key);
        String url = this.DOMAIN_NAME + "/api/cps/v1/download/" + download_id;
        this.logger.info("WPS\u4e2d\u53f0URL\uff1a" + url);
        return this.fileDownloadGet(url, headers);
    }

    public OfficeResult fileConvert(ConvertInfo convertInfo) {
        String json = JSONUtil.toJsonStr((Object)convertInfo);
        WPS4Signature signature = new WPS4Signature(this.AK, this.SK);
        Map<String, String> headers = signature.getSignatureHeaders("POST", "/api/cps/sync/v1/convert", json, new Date(), "application/json");
        String url = this.DOMAIN_NAME + "/api/cps/sync/v1/convert";
        this.logger.info("WPS\u4e2d\u53f0URL\uff1a" + url);
        OfficeResult OfficeResult2 = this.post(url, json, headers);
        return OfficeResult2;
    }

    public OfficeResult getPreviewURl(String fileId, String fileName) {
        return this.getPreviewURl(fileId, fileName, null, null, null);
    }

    public OfficeResult getPreviewURl(String fileId, String fileName, PreviewMode previewMode, String wpsPreview, Integer _w_tokentype) {
        return this.getPreviewURl(fileId, fileName, previewMode, wpsPreview, _w_tokentype, null);
    }

    public OfficeResult getPreviewURl(String fileId, String fileName, PreviewMode previewMode, String wpsPreview, Integer _w_tokentype, Map<String, String> params) {
        String type = WPSFileTypeUtil.openEdit(fileName);
        String url = "/api/preview/v1/files/{file_id}/link".replace("${file_id}", fileId) + "?type=" + type;
        if (null != _w_tokentype && _w_tokentype.equals(1)) {
            url = url + "&_w_tokentype=" + _w_tokentype;
        }
        if (null != previewMode) {
            url = url + "&preview_mode=" + (Object)((Object)previewMode);
        }
        if (null != wpsPreview) {
            url = url + "&wpsPreview=" + wpsPreview;
        }
        if (null != params && params.size() > 0) {
            Set<String> keySet = params.keySet();
            CharSequence[] keyArr = new String[keySet.size()];
            int i = 0;
            for (String key : keySet) {
                String value = params.get(key);
                keyArr[i] = "_w_third_" + key + "=" + value;
                ++i;
            }
            url = url + "&" + String.join((CharSequence)"&", keyArr);
        }
        WPS4Signature signature = new WPS4Signature(this.AK, this.SK);
        Map<String, String> headers = signature.getSignatureHeaders("GET", url, "", new Date(), "application/json");
        url = this.DOMAIN_NAME + url;
        this.logger.info("WPS\u4e2d\u53f0URL\uff1a" + url);
        OfficeResult OfficeResult2 = this.get(url, headers);
        return OfficeResult2;
    }

    public OfficeResult getEditURl(String fileId, String fileName) {
        return this.getEditURl(fileId, fileName, null);
    }

    public OfficeResult getEditURl(String fileId, String fileName, Integer _w_tokentype) {
        return this.getEditURl(fileId, fileName, _w_tokentype, null);
    }

    public OfficeResult getEditURl(String fileId, String fileName, Integer _w_tokentype, Map<String, String> params) {
        String type = WPSFileTypeUtil.openEdit(fileName);
        String url = "/api/edit/v1/files/${file_id}/link".replace("${file_id}", fileId) + "?type=" + type;
        if (null != _w_tokentype && _w_tokentype.equals(1)) {
            url = url + "&_w_tokentype=" + _w_tokentype;
        }
        if (null != params && params.size() > 0) {
            Set<String> keySet = params.keySet();
            CharSequence[] keyArr = new String[keySet.size()];
            int i = 0;
            for (String key : keySet) {
                String value = params.get(key);
                keyArr[i] = "_w_third_" + key + "=" + value;
                ++i;
            }
            url = url + "&" + String.join((CharSequence)"&", keyArr);
        }
        WPS4Signature signature = new WPS4Signature(this.AK, this.SK);
        Map<String, String> headers = signature.getSignatureHeaders("GET", url, "", new Date(), "application/json");
        url = this.DOMAIN_NAME + url;
        this.logger.info("WPS\u4e2d\u53f0URL\uff1a" + url);
        OfficeResult OfficeResult2 = this.get(url, headers);
        this.logger.info("\u6587\u4ef6\u7f16\u8f91URL\uff1a" + OfficeResult2.getData());
        return OfficeResult2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fileDownloadGet(String url, Map<String, String> headers) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        ByteArrayOutputStream outputStream = null;
        try {
            httpClient = this.wrapClient();
            HttpGet httpGet = new HttpGet(url);
            if (null != headers) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpGet.addHeader(entry.getKey(), entry.getValue());
                }
            }
            response = httpClient.execute((HttpUriRequest)httpGet);
            outputStream = new ByteArrayOutputStream();
            response.getEntity().writeTo((OutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                outputStream.close();
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfficeResult get(String url, Map<String, String> headers) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String responseBody = "";
        try {
            httpClient = this.wrapClient();
            HttpGet httpGet = new HttpGet(url);
            if (null != headers) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpGet.addHeader(entry.getKey(), entry.getValue());
                }
            }
            response = httpClient.execute((HttpUriRequest)httpGet);
            System.out.println("Response Code: " + response.getStatusLine().getStatusCode());
            HttpEntity entity = response.getEntity();
            responseBody = EntityUtils.toString((HttpEntity)entity);
            System.out.println("Response Body: " + responseBody);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int code = response.getStatusLine().getStatusCode();
        JSONObject jsonObject = (JSONObject)JSONUtil.toBean((String)responseBody, JSONObject.class);
        return this.getOfficeResult(code, jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfficeResult post(String url, String json, Map<String, String> headers) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String responseBody = "";
        try {
            httpClient = this.wrapClient();
            HttpPost httpPost = new HttpPost(url);
            if (null != headers) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpEntity httpEntity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(json).setContentEncoding(StandardCharsets.UTF_8.name()).build();
            httpPost.setEntity(httpEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            System.out.println("Response Code: " + response.getStatusLine().getStatusCode());
            HttpEntity entity = response.getEntity();
            responseBody = EntityUtils.toString((HttpEntity)entity);
            System.out.println("Response Body: " + responseBody);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int code = response.getStatusLine().getStatusCode();
        JSONObject jsonObject = (JSONObject)JSONUtil.toBean((String)responseBody, JSONObject.class);
        return this.getOfficeResult(code, jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfficeResult<String> filePost(String url, byte[] bytes, String fileName, Map<String, Object> params) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String responseBody = "";
        try {
            httpClient = this.wrapClient();
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody("file", bytes, ContentType.MULTIPART_FORM_DATA, fileName);
            if (params != null) {
                for (String key : params.keySet()) {
                    builder.addTextBody(key, String.valueOf(params.get(key)), ContentType.APPLICATION_JSON);
                }
            }
            HttpEntity reqEntity = builder.build();
            httpPost.setEntity(reqEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            System.out.println("Response Code: " + response.getStatusLine().getStatusCode());
            HttpEntity entity = response.getEntity();
            responseBody = EntityUtils.toString((HttpEntity)entity);
            System.out.println("Response Body: " + responseBody);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int code = response.getStatusLine().getStatusCode();
        JSONObject jsonObject = (JSONObject)JSONUtil.toBean((String)responseBody, JSONObject.class);
        return this.getOfficeResult(code, jsonObject);
    }

    private OfficeResult getOfficeResult(int code, JSONObject jsonObject) {
        OfficeResult<String> OfficeResult2 = null;
        if (code == 200 && jsonObject.getInt((Object)"code") == 200) {
            OfficeResult2 = new OfficeResult<String>(code, jsonObject.getStr((Object)"msg"));
            OfficeResult2.setCode(jsonObject.getInt((Object)"code"));
            OfficeResult2.setData(jsonObject.getStr((Object)"data"));
            return OfficeResult2;
        }
        code = jsonObject.getInt((Object)"code");
        String msg = ErrorCode.getValueByCode(code);
        if (code == 40007) {
            msg = jsonObject.getStr((Object)"hint");
        }
        throw new IllegalStateException(code + "==" + msg);
    }

    private CloseableHttpClient wrapClient() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }
            };
            ctx.init(null, new TrustManager[]{trustManager}, null);
            SSLConnectionSocketFactory ssf = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)ssf).build();
        }
        catch (Exception e) {
            return HttpClients.createDefault();
        }
    }

    public void main(String[] args) {
        PreviewMode cache = PreviewMode.cache;
        System.out.println((Object)cache);
    }

    static enum ErrorCode {
        SessionExpired(40002, "token\u8fc7\u671f"),
        PermissionDenied(40003, "\u7528\u6237\u65e0\u6743\u9650\u8bbf\u95ee"),
        NotExists(40004, "\u8d44\u6e90\u4e0d\u5b58\u5728"),
        InvalidArgument(40005, "\u53c2\u6570\u9519\u8bef"),
        SpaceFull(40006, "\u4fdd\u5b58\u7a7a\u95f4\u5df2\u6ee1"),
        CustomMsg(40007, ""),
        FnameConflict(40008, "\u6587\u4ef6\u91cd\u547d\u540d\u51b2\u7a81"),
        ServerError(50001, "\u5bf9\u63a5\u7cfb\u7edf\u9519\u8bef"),
        CodeParamFormatError(40000002, "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u6709\u8bef"),
        CodeResourceNotFound(40000103, "\u670d\u52a1\u6ce8\u518c\u6821\u9a8c\uff0c\u670d\u52a1\u672a\u6ce8\u518c\u6216\u67e5\u770brouter_register_info\u8868\u662f\u5426"),
        CodeRemoteFai(40000201, "\u8fdc\u7a0b\u8c03\u7528\u5931\u8d25\uff08\u5ba2\u6237\u7aef\u9519\u8bef\uff09"),
        CodeAuthError(40100001, "\u8ba4\u8bc1\u9519\u8bef"),
        Code400Begin(40010001, "\u7ba1\u7406\u540e\u53f0\u4e1a\u52a1\u63a5\u53e3\u5f02\u5e38"),
        CodeRemoteError(50000001, "\u8f6c\u53d1\u8bf7\u6c42\u7684\u670d\u52a1\u65e0\u54cd\u5e94\u6216\u65e0\u6548\u7684IP\u8bbf\u95ee");

        Integer code;
        String value;

        private ErrorCode(Integer code, String value) {
            this.code = code;
            this.value = value;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(Integer code) {
            for (ErrorCode errorCode : ErrorCode.values()) {
                if (!errorCode.code.equals(code)) continue;
                return errorCode.value;
            }
            return "";
        }
    }
}

