/*
 * Decompiled with CFR 0.152.
 */
package com.office.tools.wps;

import com.office.tools.wps.HMacUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class WPS4Signature {
    public static final String HTTP_HEADER_AUTHORIZATION = "Wps-Docs-Authorization";
    public static final String HTTP_HEADER_DATE = "Wps-Docs-Date";
    public static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private String appId;
    private String secretKey;

    public WPS4Signature(String appId, String secretKey) {
        this.appId = appId;
        this.secretKey = secretKey;
    }

    public String getSHA256(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return HMacUtils.getSHA256StrJava("".getBytes());
        }
        return HMacUtils.getSHA256StrJava(content.getBytes());
    }

    public static String getGMTDateString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(date) + " GMT";
    }

    public String getSignature(String method, String uriWithQuerystring, String contentMD5, String dateString, String contentType) throws Exception {
        return HMacUtils.HMACSHA256("WPS-4" + method + uriWithQuerystring + contentType + dateString + contentMD5, this.secretKey);
    }

    public String getAuthorization(String method, String uriWithQuerystring, String contentMD5, String dateString, String contentType) throws Exception {
        String authorization = String.format(Locale.US, "WPS-4 %s:%s", this.appId, this.getSignature(method, uriWithQuerystring, contentMD5, dateString, contentType));
        return authorization;
    }

    public Map<String, String> getSignatureHeaders(String method, String uriWithQuerystring, String content, Date date, String contentType) {
        if (uriWithQuerystring == null) {
            uriWithQuerystring = "";
        }
        content = content == null || StringUtils.isBlank((CharSequence)content) ? "" : this.getSHA256(content);
        if (date == null) {
            date = new Date();
        }
        if (contentType == null) {
            contentType = "application/json";
        }
        String dateString = WPS4Signature.getGMTDateString(date);
        String authorization = "";
        try {
            authorization = this.getAuthorization(method, uriWithQuerystring, content, dateString, contentType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HTTP_HEADER_AUTHORIZATION, authorization);
        headers.put(HTTP_HEADER_CONTENT_TYPE, contentType);
        headers.put(HTTP_HEADER_DATE, dateString);
        return headers;
    }
}

