/*
 * Decompiled with CFR 0.152.
 */
package com.office.tools.wps;

import com.office.tools.FileUtil;
import java.util.Arrays;
import java.util.List;

public class WPSFileTypeUtil {
    private static List<String> ExtsDocument = Arrays.asList("doc", "docx", "docm", "dot", "dotx", "dotm", "wps", "wpt");
    private static List<String> ExtsSpreadsheet = Arrays.asList("xls", "xlsx", "xlsm", "xlt", "xltx", "xltm", "et");
    private static List<String> ExtsPresentation = Arrays.asList("pps", "ppsx", "ppsm", "ppt", "pptx", "pptm", "dpt", "potx", "potm", "dps");
    private static List<String> previewDocument = Arrays.asList("doc", "docx", "docm", "dot", "dotx", "dotm", "wps", "wpt", "rtf", "txt", "mht", "mhtml", "htm", "html", "uot3");
    private static List<String> previewSpreadsheet = Arrays.asList("xls", "xlsx", "xlsm", "xlt", "xltx", "xltm", "et", "ett", "csv");
    private static List<String> previewPresentation = Arrays.asList("pps", "ppsx", "ppsm", "ppt", "pptx", "pptm", "dpt", "potx", "potm", "dps");
    private static List<String> previewX = Arrays.asList("jpeg", "jpg", "png", "gif", "bmp", "tif", "tiff", "svg", "psd", "tar", "zip", "7z", "jar", "rar", "gzip", "md", "c", "cpp", "java", "js", "css", "lrc", "h", "asm", "s", "asp", "bat", "bas", "prg", "cmd", "xml", "log", "ini", "inf", "cdr", "vsd", "vsdx");
    private static String PDF = "pdf";
    private static String OFD = "ofd";

    public static String openEdit(String fileName) {
        String ext = FileUtil.getFileExtension(fileName);
        if (ExtsDocument.contains(ext)) {
            return FileType.W.toString().toLowerCase();
        }
        if (ExtsSpreadsheet.contains(ext)) {
            return FileType.S.toString().toLowerCase();
        }
        if (ExtsPresentation.contains(ext)) {
            return FileType.P.toString().toLowerCase();
        }
        if (PDF.equals(ext)) {
            return FileType.F.toString().toLowerCase();
        }
        throw new IllegalArgumentException("\u3010" + ext + "\u3011\u65e0\u6548\u6587\u4ef6\u7c7b\u578b");
    }

    public static String openPreview(String fileName) {
        String ext = FileUtil.getFileExtension(fileName);
        if (previewDocument.contains(ext)) {
            return FileType.W.toString().toLowerCase();
        }
        if (previewSpreadsheet.contains(ext)) {
            return FileType.S.toString().toLowerCase();
        }
        if (previewPresentation.contains(ext)) {
            return FileType.P.toString().toLowerCase();
        }
        if (PDF.equals(ext) || OFD.equals(ext)) {
            return FileType.F.toString().toLowerCase();
        }
        if (previewX.contains(ext)) {
            return FileType.X.toString().toLowerCase();
        }
        throw new IllegalArgumentException("\u3010" + ext + "\u3011\u65e0\u6548\u6587\u4ef6\u7c7b\u578b");
    }

    static enum FileType {
        W,
        S,
        P,
        F,
        X;

    }
}

