/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.model.sign.Signature;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;

public class QbhClient
extends HttpClient {
    private String engineType;
    private String aue;
    private String sampleRate;

    public QbhClient(Builder builder) {
        super((HttpBuilder)builder);
        this.engineType = builder.engineType;
        this.aue = builder.aue;
        this.sampleRate = builder.sampleRate;
    }

    public String send(byte[] data) throws IOException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("engine_type", this.engineType);
        jsonObject.addProperty("aue", this.aue);
        jsonObject.addProperty("sample_rate", this.sampleRate);
        Map header = Signature.signHttpHeaderCheckSum((String)this.appId, (String)this.apiKey, (String)jsonObject.toString());
        return this.sendPost(this.hostUrl, FORM, header, data);
    }

    public String getEngineType() {
        return this.engineType;
    }

    public String getAue() {
        return this.aue;
    }

    public String getSampleRate() {
        return this.sampleRate;
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://webqbh.xfyun.cn/v1/service/v1/qbh";
        private String engineType = "afs";
        private String aue = "raw";
        private String sampleRate = "16000";

        public Builder(String appId, String apiKey) {
            super(HOST_URL, appId, apiKey, null);
            this.connectTimeout(10);
            this.readTimeout(10);
            this.writeTimeout(10);
        }

        public Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        public Builder aue(String aue) {
            this.aue = aue;
            return this;
        }

        public Builder sampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public QbhClient build() {
            return new QbhClient(this);
        }
    }
}

