/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.webscoket.WebSocketClient;
import cn.xfyun.model.sign.AbstractSignature;
import cn.xfyun.model.sign.RtasrSignature;
import cn.xfyun.service.rta.AbstractRtasrWebSocketListener;
import cn.xfyun.service.rta.RtasrSendTask;
import java.io.Closeable;
import java.io.InputStream;
import java.security.SignatureException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;

public class RtasrClient
extends WebSocketClient {
    private static final String RTASR_URL = "wss://rtasr.xfyun.cn/v1/ws";
    public static final String SEND_END = "{\"end\": true}";
    private String punc;
    private String pd;
    private static ExecutorService executorService = Executors.newSingleThreadExecutor();

    public RtasrClient(Builder builder) {
        this.okHttpClient = new OkHttpClient().newBuilder().build();
        this.appId = builder.appId;
        this.apiKey = builder.apiKey;
        this.request = builder.request;
        this.webSocket = builder.webSocket;
        this.pd = builder.pd;
        this.punc = builder.punc;
        if (Objects.isNull(builder.hostUrl)) {
            this.originHostUrl = RTASR_URL;
            this.hostUrl = RTASR_URL;
        } else {
            this.originHostUrl = builder.hostUrl;
            this.hostUrl = builder.hostUrl;
        }
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
        this.callTimeout = builder.callTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.pingInterval = builder.pingInterval;
    }

    protected void createWebSocketConnect(WebSocketListener webSocketListener) throws SignatureException {
        this.signature = new RtasrSignature(this.appId, this.apiKey);
        String url = RTASR_URL + this.signature.getSigna();
        this.request = new Request.Builder().url(url).build();
        this.webSocket = this.okHttpClient.newWebSocket(this.request, webSocketListener);
    }

    public void send(InputStream inputStream, AbstractRtasrWebSocketListener webSocketListener) throws SignatureException {
        this.createWebSocketConnect(webSocketListener);
        if (inputStream == null) {
            this.webSocket.close(1000, null);
            return;
        }
        RtasrSendTask rtasrSendTask = new RtasrSendTask();
        new RtasrSendTask.Builder().inputStream(inputStream).webSocket(this.webSocket).build(rtasrSendTask);
        executorService.submit(rtasrSendTask);
    }

    public void send(byte[] bytes, Closeable closeable, AbstractRtasrWebSocketListener webSocketListener) throws SignatureException {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        this.createWebSocketConnect(webSocketListener);
        RtasrSendTask iatSendTask = new RtasrSendTask();
        new RtasrSendTask.Builder().bytes(bytes).webSocket(this.webSocket).closeable(closeable).build(iatSendTask);
        executorService.submit(iatSendTask);
    }

    public WebSocket newWebSocket(AbstractRtasrWebSocketListener webSocketListener) {
        String url = RTASR_URL + new RtasrSignature(this.appId, this.apiKey).getSigna();
        this.request = new Request.Builder().url(url).build();
        this.webSocket = this.okHttpClient.newWebSocket(this.request, (WebSocketListener)webSocketListener);
        return this.webSocket;
    }

    public void sendEnd() {
        this.webSocket.send(SEND_END);
        this.closeWebsocket();
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public String getPunc() {
        return this.punc;
    }

    public String getPd() {
        return this.pd;
    }

    public String getHostUrl() {
        return this.originHostUrl;
    }

    public String getOriginHostUrl() {
        return this.originHostUrl;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public boolean isRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public int getCallTimeout() {
        return this.callTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public Request getRequest() {
        return this.request;
    }

    public AbstractSignature getSignature() {
        return this.signature;
    }

    public static final class Builder {
        boolean retryOnConnectionFailure = true;
        int callTimeout = 0;
        int connectTimeout = 10000;
        int readTimeout = 10000;
        int writeTimeout = 10000;
        int pingInterval = 0;
        private String hostUrl;
        private String appId;
        private String apiKey;
        private Request request;
        private WebSocket webSocket;
        private String punc;
        private String pd;

        public Builder request(Request request) {
            this.request = request;
            return this;
        }

        public Builder webSocket(WebSocket webSocket) {
            this.webSocket = webSocket;
            return this;
        }

        public Builder addPunc() {
            this.punc = "0";
            return this;
        }

        public Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public Builder addPd(String pd) {
            this.pd = pd;
            return this;
        }

        public Builder callTimeout(long timeout, TimeUnit unit) {
            this.callTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder readTimeout(long timeout, TimeUnit unit) {
            this.readTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder writeTimeout(long timeout, TimeUnit unit) {
            this.writeTimeout = Util.checkDuration((String)"timeout", (long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder pingInterval(long interval, TimeUnit unit) {
            this.pingInterval = Util.checkDuration((String)"interval", (long)interval, (TimeUnit)unit);
            return this;
        }

        public Builder retryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder signature(String appId, String apiKey) {
            this.appId = appId;
            this.apiKey = apiKey;
            return this;
        }

        public RtasrClient build() {
            RtasrClient rtasrClient = new RtasrClient(this);
            return rtasrClient;
        }
    }
}

