/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.eop.api;

import com.ailk.ecs.ssp.eop.api.ApiException;
import com.ailk.ecs.ssp.eop.api.Req;
import com.ailk.ecs.ssp.eop.api.Rsp;
import com.ailk.ecs.ssp.eop.api.internal.parser.json.ObjectJsonParser;
import com.ailk.ecs.ssp.eop.api.internal.parser.xml.ObjectXmlParser;
import com.ailk.ecs.ssp.eop.api.internal.util.Base64;
import com.ailk.ecs.ssp.eop.api.internal.util.ByteUtils;
import com.ailk.ecs.ssp.eop.api.internal.util.EopConst;
import com.ailk.ecs.ssp.eop.api.internal.util.EopLogger;
import com.ailk.ecs.ssp.eop.api.internal.util.EopMap;
import com.ailk.ecs.ssp.eop.api.internal.util.EopUtils;
import com.ailk.ecs.ssp.eop.api.internal.util.HttpRsp;
import com.ailk.ecs.ssp.eop.api.internal.util.Pair;
import com.ailk.ecs.ssp.eop.api.internal.util.StringUtils;
import com.ailk.ecs.ssp.eop.api.internal.util.Strings;
import com.ailk.ecs.ssp.eop.api.internal.util.WebUtils;
import com.ailk.ecs.ssp.network.clientupstream.SspServiceUpstream;
import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class EopClient {
    private final String serverUrls;
    private final String serverUrl;
    private final String appcode;
    private String signKey;
    private String signAlgorithm = "MD5";
    private String paramKey;
    private String paramAlgorithm = "AES";
    private String fmt;
    private String signInfo;
    private String priKey;
    private Map<String, String> accessMap;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private Proxy proxy;
    private String proxyAuthorization;
    private static LoadingCache<String, SspServiceUpstream> cacheServers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, SspServiceUpstream>(){

        public SspServiceUpstream load(String key) {
            return new SspServiceUpstream(key);
        }
    });

    public EopClient(String serverUrl, String appcode, String signKey) {
        this.serverUrls = serverUrl;
        this.serverUrl = ((SspServiceUpstream)cacheServers.getUnchecked((Object)serverUrl)).getEndPoint();
        this.appcode = appcode;
        this.signKey = signKey;
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
    }

    public void setProxyAuthorization(String userName, String password) {
        this.proxyAuthorization = Base64.encodeToString(ByteUtils.toBytes(String.valueOf(userName) + ':' + password), false);
    }

    public <T extends Rsp> T execute(Req<T> request) throws ApiException {
        HttpRsp rt = null;
        try {
            rt = this.doPost(request);
        }
        catch (ApiException e) {
            if (e.getCause().getMessage().contains("java.net.SocketTimeoutException: connect timed out")) {
                ((SspServiceUpstream)cacheServers.getUnchecked((Object)this.serverUrls)).downIncrease(this.serverUrl);
            }
            throw e;
        }
        if (rt == null) {
            return null;
        }
        String contentType = rt.getContentType();
        Class<T> respClass = request.getRspClass();
        ObjectJsonParser<T> parser = contentType != null && contentType.contains("text/xml") ? new ObjectXmlParser<T>(respClass) : new ObjectJsonParser<T>(respClass);
        Rsp tRsp = null;
        String rspMsg = rt.getContent();
        try {
            tRsp = (Rsp)parser.parse(rspMsg);
            tRsp.setRspSignCheckResult(EopUtils.checkSign(this.signAlgorithm, this.signKey, tRsp.getRspmsg(), tRsp.getRspsign(), this.priKey));
        }
        catch (Exception e) {
            EopLogger.logBizError(rspMsg);
            tRsp.setRspSignCheckResult(false);
        }
        if (!tRsp.isSuccess()) {
            EopLogger.logErrorScene(rt, tRsp, this.signKey);
        }
        tRsp.setQueryString(rt.getQuery());
        return (T)tRsp;
    }

    private <T extends Rsp> HttpRsp doPost(Req<T> request) throws ApiException {
        EopMap securetKeyValueParams;
        EopMap actionParams = new EopMap(request.getParams());
        actionParams.put(EopConst.EOP_APPCODE, this.appcode);
        if (!StringUtils.isEmpty(this.fmt)) {
            actionParams.put(EopConst.EOP_FMT, this.fmt);
        }
        if (!StringUtils.isEmpty(request.getApptx())) {
            actionParams.put(EopConst.EOP_APPTX, request.getApptx());
        }
        if (request.isMock()) {
            actionParams.put(EopConst.EOP_MOCK, "true");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        actionParams.put(EopConst.EOP_REQTS, formatter.format(new Date()).trim());
        EopMap securetValueParams = request.getSecuretValueParams();
        if (securetValueParams != null && securetValueParams.size() > 0) {
            for (Map.Entry securetValueEntry : securetValueParams.entrySet()) {
                actionParams.put((String)securetValueEntry.getKey(), EopUtils.createSecuret(this.paramAlgorithm, this.paramKey, (String)securetValueEntry.getValue()));
            }
        }
        if ((securetKeyValueParams = request.getSecuretKeyValueParams()) != null && securetKeyValueParams.size() > 0) {
            String eopCipher = EopUtils.createQueryString(securetKeyValueParams);
            actionParams.put(EopConst.EOP_CIPHER, EopUtils.createSecuret(this.paramAlgorithm, this.paramKey, eopCipher));
        }
        String sign = "";
        try {
            if (!Strings.isBlank(this.signKey)) {
                Pair<String, String> signPair = EopUtils.signEopRequest(this.signAlgorithm, actionParams, this.signKey, this.priKey);
                sign = signPair.getFirst();
                this.signInfo = signPair.getSecond();
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        actionParams.put(EopConst.EOP_SIGN, sign);
        actionParams.put(EopConst.EOP_ACCESS, JSON.toJSONString(this.accessMap));
        try {
            return WebUtils.doPost(this.proxy, this.proxyAuthorization, this.serverUrl, actionParams, this.connectTimeout, this.readTimeout);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public void setSignAlgorithm(String signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
    }

    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public String getSignKey() {
        return this.signKey;
    }

    public String getFormat() {
        return this.fmt;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    public void setFormat(String format) {
        this.fmt = format;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setParamKey(String paramKey) {
        this.paramKey = paramKey;
    }

    public String getParamKey() {
        return this.paramKey;
    }

    public void setParamAlgorithm(String paramAlgorithm) {
        this.paramAlgorithm = paramAlgorithm;
    }

    public String getParamAlgorithm() {
        return this.paramAlgorithm;
    }

    public String getSignInfo() {
        return this.signInfo;
    }

    public String getPriKey() {
        return this.priKey;
    }

    public void setPriKey(String priKey) {
        this.priKey = priKey;
    }

    public Map<String, String> getAccessMap() {
        return this.accessMap;
    }

    public void setAccessMap(Map<String, String> accessMap) {
        this.accessMap = accessMap;
    }
}

