/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.eop.api.internal.mapping;

import com.ailk.ecs.ssp.eop.api.ApiException;
import com.ailk.ecs.ssp.eop.api.internal.mapping.Reader;
import com.ailk.ecs.ssp.eop.api.internal.mapping.RspField;
import com.ailk.ecs.ssp.eop.api.internal.mapping.RspListItem;
import com.ailk.ecs.ssp.eop.api.internal.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class Converters {
    private static Map<Class, Class> primitiveMap = new HashMap<Class, Class>();
    public static boolean isCheckJsonType;

    static {
        primitiveMap.put(Boolean.TYPE, Boolean.class);
        primitiveMap.put(Byte.TYPE, Byte.class);
        primitiveMap.put(Character.TYPE, Character.class);
        primitiveMap.put(Short.TYPE, Short.class);
        primitiveMap.put(Integer.TYPE, Integer.class);
        primitiveMap.put(Long.TYPE, Long.class);
        primitiveMap.put(Float.TYPE, Float.class);
        primitiveMap.put(Double.TYPE, Double.class);
        primitiveMap.put(String.class, String.class);
        isCheckJsonType = false;
    }

    private Converters() {
    }

    public static <T> void convert(T rsp, Reader reader) throws ApiException {
        try {
            PropertyDescriptor[] pds;
            Class<?> clazz = rsp.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
            PropertyDescriptor[] propertyDescriptorArray = pds = beanInfo.getPropertyDescriptors();
            int n = pds.length;
            int n2 = 0;
            while (n2 < n) {
                block52: {
                    PropertyDescriptor pd = propertyDescriptorArray[n2];
                    Method method = pd.getWriteMethod();
                    if (method != null) {
                        String itemName = pd.getName();
                        Field field = null;
                        try {
                            field = clazz.getDeclaredField(itemName);
                        }
                        catch (NoSuchFieldException ex) {
                            break block52;
                        }
                        RspField jsonField = field.getAnnotation(RspField.class);
                        if (jsonField != null) {
                            Class typeClass;
                            if (!StringUtils.isEmpty(jsonField.value())) {
                                itemName = jsonField.value();
                            }
                            if ((typeClass = field.getType()).isPrimitive()) {
                                typeClass = primitiveMap.get(typeClass);
                            }
                            if (List.class.isAssignableFrom(typeClass) || reader.hasReturnField(itemName)) {
                                Object value;
                                if (String.class.isAssignableFrom(typeClass)) {
                                    value = reader.getPrimitiveObject(itemName);
                                    if (value instanceof String) {
                                        method.invoke(rsp, value.toString());
                                    } else {
                                        if (isCheckJsonType && value != null) {
                                            throw new ApiException(String.valueOf(itemName) + " is not a String");
                                        }
                                        if (value != null) {
                                            method.invoke(rsp, value.toString());
                                        } else {
                                            method.invoke(rsp, "");
                                        }
                                    }
                                } else if (Long.class.isAssignableFrom(typeClass)) {
                                    value = reader.getPrimitiveObject(itemName);
                                    if (value instanceof Long) {
                                        method.invoke(rsp, (Long)value);
                                    } else {
                                        if (isCheckJsonType && value != null) {
                                            throw new ApiException(String.valueOf(itemName) + " is not a Number(Long)");
                                        }
                                        if (StringUtils.isNumeric(value)) {
                                            method.invoke(rsp, Long.valueOf("" + value));
                                        }
                                    }
                                } else if (Integer.class.isAssignableFrom(typeClass)) {
                                    value = reader.getPrimitiveObject(itemName);
                                    if (value instanceof Integer) {
                                        method.invoke(rsp, (Integer)value);
                                    } else {
                                        if (isCheckJsonType && value != null) {
                                            throw new ApiException(String.valueOf(itemName) + " is not a Number(Integer)");
                                        }
                                        if (StringUtils.isNumeric(value)) {
                                            method.invoke(rsp, Integer.valueOf("" + value));
                                        }
                                    }
                                } else if (Boolean.class.isAssignableFrom(typeClass)) {
                                    value = reader.getPrimitiveObject(itemName);
                                    if (value instanceof Boolean) {
                                        method.invoke(rsp, (Boolean)value);
                                    } else {
                                        if (isCheckJsonType && value != null) {
                                            throw new ApiException(String.valueOf(itemName) + " is not a Boolean");
                                        }
                                        if (value != null) {
                                            method.invoke(rsp, Boolean.valueOf(value.toString()));
                                        }
                                    }
                                } else if (Double.class.isAssignableFrom(typeClass)) {
                                    value = reader.getPrimitiveObject(itemName);
                                    if (value instanceof Double) {
                                        method.invoke(rsp, (Double)value);
                                    } else if (isCheckJsonType && value != null) {
                                        throw new ApiException(String.valueOf(itemName) + " is not a Double");
                                    }
                                } else if (Number.class.isAssignableFrom(typeClass)) {
                                    value = reader.getPrimitiveObject(itemName);
                                    if (value instanceof Number) {
                                        method.invoke(rsp, (Number)value);
                                    } else if (isCheckJsonType && value != null) {
                                        throw new ApiException(String.valueOf(itemName) + " is not a Number");
                                    }
                                } else if (Date.class.isAssignableFrom(typeClass)) {
                                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                                    Object value2 = reader.getPrimitiveObject(itemName);
                                    if (value2 instanceof String) {
                                        method.invoke(rsp, format.parse(value2.toString()));
                                    }
                                } else if (List.class.isAssignableFrom(typeClass)) {
                                    RspListItem listItem;
                                    Class subType;
                                    List<?> listObjs;
                                    ParameterizedType paramType;
                                    Type[] genericTypes;
                                    Type fieldType = field.getGenericType();
                                    if (fieldType instanceof ParameterizedType && (genericTypes = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()) != null && genericTypes.length > 0 && genericTypes[0] instanceof Class && (listObjs = reader.getListObjects(itemName, subType = (Class)genericTypes[0], (listItem = field.getAnnotation(RspListItem.class)) == null ? "item" : listItem.value())) != null) {
                                        method.invoke(rsp, listObjs);
                                    }
                                } else {
                                    Object obj = reader.getObject(itemName, typeClass);
                                    if (obj != null) {
                                        method.invoke(rsp, obj);
                                    }
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
    }
}

