/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.eop.api.internal.parser.json;

import com.ailk.ecs.ssp.eop.api.ApiException;
import com.ailk.ecs.ssp.eop.api.EopRsp;
import com.ailk.ecs.ssp.eop.api.Rsp;
import com.ailk.ecs.ssp.eop.api.internal.mapping.Converter;
import com.ailk.ecs.ssp.eop.api.internal.mapping.Converters;
import com.ailk.ecs.ssp.eop.api.internal.mapping.Reader;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonConverter
implements Converter {
    public static JSON parseJSON(String rsp) {
        try {
            return JSON.parseObject((String)rsp);
        }
        catch (Throwable throwable) {
            try {
                return JSON.parseArray((String)rsp);
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    @Override
    public <T extends Rsp> T toResponse(String rsp, Class<T> clazz) throws ApiException {
        JSON rootObj = JsonConverter.parseJSON(rsp);
        if (rootObj instanceof Map) {
            Rsp rspObject;
            try {
                rspObject = (Rsp)clazz.newInstance();
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
            Map rootJson = (Map)rootObj;
            rspObject.setRspcode((String)rootJson.get("rspcode"));
            rspObject.setRspdesc((String)rootJson.get("rspdesc"));
            rspObject.setTrxid((String)rootJson.get("trxid"));
            rspObject.setTransid((String)rootJson.get("transid"));
            rspObject.setRspts("" + rootJson.get("rspts"));
            rspObject.setRspsign((String)rootJson.get("rspsign"));
            rspObject.setRspmsg(rootJson.get("rspmsg").toString());
            JSON object = JsonConverter.parseJSON(rspObject.getRspmsg());
            if (object instanceof Map) {
                this.fromJson((Map)object, rspObject);
            } else if (object instanceof List) {
                HashMap<String, JSON> hashMap = new HashMap<String, JSON>();
                hashMap.put("items", object);
                this.fromJson(hashMap, rspObject);
            }
            return (T)rspObject;
        }
        return null;
    }

    public <T> void fromJson(final Map<?, ?> json, T rsp) throws ApiException {
        if (rsp instanceof EopRsp) {
            EopRsp eopRsp = (EopRsp)rsp;
            eopRsp.setResult(json);
            return;
        }
        Converters.convert(rsp, new Reader(){

            @Override
            public boolean hasReturnField(Object name) {
                return json.containsKey(name);
            }

            @Override
            public Object getPrimitiveObject(Object name) {
                return json.get(name);
            }

            @Override
            public Object getObject(Object name, Class<?> type) throws ApiException {
                Object tmp = json.get(name);
                if (tmp instanceof Map) {
                    Object newInstance;
                    Map map = (Map)tmp;
                    try {
                        newInstance = type.newInstance();
                    }
                    catch (Exception e) {
                        throw new ApiException(e);
                    }
                    JsonConverter.this.fromJson(map, newInstance);
                }
                return null;
            }

            @Override
            public List<?> getListObjects(Object itemName, Class<?> subType, String item) throws ApiException {
                ArrayList listObjs = null;
                Object listTmp = json.get(itemName);
                if (listTmp == null) {
                    listTmp = json.get("items");
                }
                if (listTmp instanceof List) {
                    listObjs = new ArrayList();
                    List tmpList = (List)listTmp;
                    for (Object subTmp : tmpList) {
                        if (subTmp instanceof Map) {
                            Map subMap = (Map)subTmp;
                            Object subObj = null;
                            try {
                                subObj = subType.newInstance();
                            }
                            catch (Exception e) {
                                throw new ApiException(e);
                            }
                            JsonConverter.this.fromJson(subMap, subObj);
                            listObjs.add(subObj);
                            continue;
                        }
                        if (subTmp instanceof List) continue;
                        listObjs.add(subTmp);
                    }
                }
                return listObjs;
            }
        });
    }
}

