/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.eop.api.internal.parser.xml;

import com.ailk.ecs.ssp.eop.api.ApiException;
import com.ailk.ecs.ssp.eop.api.EopRsp;
import com.ailk.ecs.ssp.eop.api.Rsp;
import com.ailk.ecs.ssp.eop.api.internal.mapping.Converter;
import com.ailk.ecs.ssp.eop.api.internal.mapping.Converters;
import com.ailk.ecs.ssp.eop.api.internal.mapping.Reader;
import com.ailk.ecs.ssp.eop.api.internal.util.XmlUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

public class XmlConverter
implements Converter {
    @Override
    public <T extends Rsp> T toResponse(String rsp, Class<T> clazz) throws ApiException {
        Element rspmsg;
        Rsp rspObject;
        Element root = XmlUtils.getRootElementFromString(rsp);
        try {
            rspObject = (Rsp)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        rspObject.setRspcode(XmlUtils.getElementValue(root, "rspcode"));
        rspObject.setRspdesc(XmlUtils.getElementValue(root, "rspdesc"));
        rspObject.setTrxid(XmlUtils.getElementValue(root, "trxid"));
        rspObject.setRspts(XmlUtils.getElementValue(root, "rspts"));
        rspObject.setRspsign(XmlUtils.getElementValue(root, "rspsign"));
        rspObject.setRspmsg(XmlUtils.getElementValue(root, "rspmsg"));
        if (XmlUtils.isXmlTagStart(rspObject.getRspmsg()) && (rspmsg = XmlUtils.getRootElementFromString(rspObject.getRspmsg())) != null) {
            this.getModelFromXML(rspmsg, rspObject);
        }
        return (T)rspObject;
    }

    private <T> void getModelFromXML(final Element element, T rspObject) throws ApiException {
        if (element == null) {
            return;
        }
        if (rspObject instanceof EopRsp) {
            EopRsp eopRsp = (EopRsp)rspObject;
            eopRsp.setResult(XmlUtils.dom2Map(element));
            return;
        }
        Converters.convert(rspObject, new Reader(){

            @Override
            public boolean hasReturnField(Object name) {
                Element childE = XmlUtils.getChildElement(element, (String)name);
                return childE != null;
            }

            @Override
            public Object getPrimitiveObject(Object name) {
                return XmlUtils.getElementValue(element, (String)name);
            }

            @Override
            public Object getObject(Object name, Class<?> type) throws ApiException {
                Element childE = XmlUtils.getChildElement(element, (String)name);
                if (childE != null) {
                    Object newInstance;
                    try {
                        newInstance = type.newInstance();
                    }
                    catch (Exception e) {
                        throw new ApiException(e);
                    }
                    XmlConverter.this.getModelFromXML(childE, newInstance);
                    return newInstance;
                }
                return null;
            }

            @Override
            public List<?> getListObjects(Object itemName, Class<?> subType, String item) throws ApiException {
                ArrayList<String> list = null;
                Element listE = XmlUtils.getElement(element, (String)itemName);
                List<Element> itemEs = null;
                itemEs = listE == null ? XmlUtils.getChildElements(element, item) : XmlUtils.getChildElements(listE, item);
                if (itemEs != null) {
                    list = new ArrayList<String>();
                    for (Element itemE : itemEs) {
                        Object obj = null;
                        String value = XmlUtils.getElementValue(itemE);
                        if (String.class.isAssignableFrom(subType)) {
                            obj = value;
                        } else if (Long.class.isAssignableFrom(subType)) {
                            obj = Long.valueOf(value);
                        } else if (Integer.class.isAssignableFrom(subType)) {
                            obj = Integer.valueOf(value);
                        } else if (Boolean.class.isAssignableFrom(subType)) {
                            obj = Boolean.valueOf(value);
                        } else {
                            if (Date.class.isAssignableFrom(subType)) {
                                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                try {
                                    obj = format.parse(value);
                                }
                                catch (ParseException e) {
                                    throw new ApiException(e);
                                }
                            }
                            try {
                                obj = subType.newInstance();
                            }
                            catch (Exception e) {
                                throw new ApiException(e);
                            }
                            XmlConverter.this.getModelFromXML(itemE, obj);
                        }
                        if (obj == null) continue;
                        list.add((String)obj);
                    }
                }
                return list;
            }
        });
    }
}

