/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.eop.api.internal.util;

import com.ailk.ecs.ssp.eop.api.Rsp;
import com.ailk.ecs.ssp.eop.api.internal.util.HttpRsp;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EopLogger {
    private static final Logger log = LoggerFactory.getLogger((String)"eop.log");
    private static final Logger clog = LoggerFactory.getLogger((String)"eop.clog");
    private static final Logger blog = LoggerFactory.getLogger((String)"eop.blog");
    private static String osName = System.getProperties().getProperty("os.name");
    private static String ip = null;

    public static String getIp() {
        if (ip == null) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ip;
    }

    public static void setIp(String ip) {
        EopLogger.ip = ip;
    }

    public static void info(String format, Object arg1, Object arg2) {
        log.info(format, arg1, arg2);
    }

    public static void logCommError(Exception e, HttpURLConnection conn, String appKey, String method, byte[] content) {
        String contentString = null;
        try {
            contentString = new String(content, "UTF-8");
            EopLogger.logCommError(e, conn, appKey, method, contentString);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void logCommError(Exception e, String url, String appKey, String method, byte[] content) {
        String contentString = null;
        try {
            contentString = new String(content, "UTF-8");
            EopLogger.logCommError(e, url, appKey, method, contentString);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
    }

    public static void logCommError(Exception e, HttpURLConnection conn, String appKey, String method, Map<String, String> params) {
        EopLogger._logCommError(e, conn, null, appKey, method, params);
    }

    public static void logCommError(Exception e, String url, String appKey, String method, Map<String, String> params) {
        EopLogger._logCommError(e, null, url, appKey, method, params);
    }

    private static void logCommError(Exception e, HttpURLConnection conn, String appKey, String method, String content) {
        Map<String, String> params = EopLogger.parseParam(content);
        EopLogger._logCommError(e, conn, null, appKey, method, params);
    }

    private static void logCommError(Exception e, String url, String appKey, String method, String content) {
        Map<String, String> params = EopLogger.parseParam(content);
        EopLogger._logCommError(e, null, url, appKey, method, params);
    }

    private static void _logCommError(Exception e, HttpURLConnection conn, String url, String appKey, String method, Map<String, String> params) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        String urlStr = null;
        String rspCode = "";
        if (conn != null) {
            try {
                urlStr = conn.getURL().toString();
                rspCode = "HTTP_ERROR_" + conn.getResponseCode();
            }
            catch (IOException iOException) {}
        } else {
            urlStr = url;
            rspCode = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(new Date()));
        sb.append("^_^");
        sb.append(method);
        sb.append("^_^");
        sb.append(appKey);
        sb.append("^_^");
        sb.append(EopLogger.getIp());
        sb.append("^_^");
        sb.append(osName);
        sb.append("^_^");
        sb.append(urlStr);
        sb.append("^_^");
        sb.append(rspCode);
        sb.append("^_^");
        sb.append(String.valueOf(e.getMessage()).replaceAll("\r\n", " "));
        clog.error(sb.toString());
    }

    private static Map<String, String> parseParam(String contentString) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (contentString == null || contentString.trim().equals("")) {
            return params;
        }
        String[] paramsArray = contentString.split("\\&");
        if (paramsArray != null) {
            String[] stringArray = paramsArray;
            int n = paramsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String[] keyValue = param.split("=");
                if (keyValue != null && keyValue.length == 2) {
                    params.put(keyValue[0], keyValue[1]);
                }
                ++n2;
            }
        }
        return params;
    }

    public static void logBizError(String rsp) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(new Date()));
        sb.append("^_^");
        sb.append(rsp);
        blog.error(sb.toString());
    }

    public static void logErrorScene(HttpRsp rt, Rsp tRsp, String appSecret) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        StringBuilder sb = new StringBuilder();
        sb.append("ErrorScene");
        sb.append("^_^");
        sb.append(tRsp.getRspcode());
        sb.append("^_^");
        sb.append(appSecret);
        sb.append("^_^");
        sb.append(ip);
        sb.append("^_^");
        sb.append(osName);
        sb.append("^_^");
        sb.append(df.format(new Date()));
        sb.append("^_^");
        sb.append("ApplicationParams:");
        sb.append(rt.getQuery());
        sb.append("^_^");
        sb.append("Body:");
        sb.append(rt.getContent());
        blog.error(sb.toString());
    }
}

