/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.eop.api.internal.util;

import com.ailk.ecs.ssp.eop.api.ApiException;
import com.ailk.ecs.ssp.eop.api.internal.util.AesUtils;
import com.ailk.ecs.ssp.eop.api.internal.util.Base64;
import com.ailk.ecs.ssp.eop.api.internal.util.ByteUtils;
import com.ailk.ecs.ssp.eop.api.internal.util.EopMap;
import com.ailk.ecs.ssp.eop.api.internal.util.Pair;
import com.ailk.ecs.ssp.eop.api.internal.util.RsaUtils;
import com.ailk.ecs.ssp.eop.api.internal.util.StringUtils;
import com.ailk.ecs.ssp.eop.api.internal.util.Strings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class EopUtils {
    private static final String KEY_MAC = "HmacMD5";

    public static Pair<String, String> signEopRequest(String signAlgorithm, EopMap actionParams, String signKey, String priKey) throws Exception {
        StringBuilder query = new StringBuilder();
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        if (actionParams != null && actionParams.size() > 0) {
            sortedParams.putAll(actionParams);
        }
        Set paramSet = sortedParams.entrySet();
        for (Map.Entry param : paramSet) {
            if (!StringUtils.areNotEmpty((String)param.getKey(), (String)param.getValue())) continue;
            query.append('$').append((String)param.getKey()).append('$').append((String)param.getValue());
        }
        String signInfo = query.toString();
        byte[] bytes = "hmac".equalsIgnoreCase(signAlgorithm) ? EopUtils.hmac(signKey, signInfo) : EopUtils.md5(String.valueOf(signKey) + signInfo + signKey);
        return Pair.makePair(RsaUtils.encrypt(Base64.encodeToString(bytes, false), priKey), signInfo);
    }

    public static boolean checkSign(String signAlgorithm, String signKey, String signInfo, String sign, String sraKey) throws Exception {
        if (Strings.isBlank(signKey)) {
            return true;
        }
        byte[] bytes = "hmac".equalsIgnoreCase(signAlgorithm) ? EopUtils.hmac(signKey, signInfo) : EopUtils.md5(String.valueOf(signKey) + signInfo + signKey);
        String encodeToString = Base64.encodeToString(bytes, false);
        return Strings.equals(RsaUtils.decrypts(sign, sraKey), encodeToString);
    }

    private static byte[] hmac(String signKey, String string) throws IOException {
        SecretKeySpec secretKey = new SecretKeySpec(Base64.decode(signKey), KEY_MAC);
        try {
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            return mac.doFinal(ByteUtils.toBytes(string));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static byte[] md5(String data) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse);
        }
    }

    public static String createEopCipher(String aeskey, String ... kvs) throws Exception {
        StringBuilder query = new StringBuilder();
        int i = 0;
        while (i < kvs.length) {
            String value;
            String name = kvs[i];
            String string = value = i + 1 < kvs.length ? kvs[i + 1] : null;
            if (StringUtils.areNotEmpty(name, value)) {
                if (i > 0) {
                    query.append("&");
                }
                try {
                    query.append(URLEncoder.encode(name, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            i += 2;
        }
        return AesUtils.encrypt(query.toString(), aeskey);
    }

    public static String createSecuret(String paramAlgorithm, String paramKey, String value) throws ApiException {
        try {
            if ("AES".equals(paramAlgorithm)) {
                return AesUtils.encrypt(value, paramKey);
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return null;
    }

    public static String createQueryString(EopMap securetKeyValueParams) {
        StringBuilder query = new StringBuilder();
        Set entrySet = securetKeyValueParams.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!StringUtils.areNotEmpty(key, value)) continue;
            if (query.length() > 0) {
                query.append("&");
            }
            try {
                query.append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return query.toString();
    }
}

