/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.eop.api.internal.util;

import com.ailk.ecs.ssp.eop.api.internal.util.Ios;
import com.ailk.ecs.ssp.eop.api.internal.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class Props {
    private static Properties properties = new Properties();

    static {
        Props.loadConfig("/eop.props");
    }

    public static synchronized void loadConfig(String configFileName) {
        block4: {
            InputStream is = null;
            try {
                is = Props.class.getResourceAsStream(configFileName);
                List<String> lines = Ios.readLines(is);
                Props.loadProperties(lines);
            }
            catch (Exception e) {
                if (is == null) break block4;
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private static void loadProperties(List<String> lines) {
        for (String line : lines) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            String key = Strings.substringBefore(line, "=").trim();
            String value = Strings.substringAfter(line, "=").trim();
            if (Strings.isEmpty(key)) continue;
            properties.put(key, value);
        }
    }

    public static String getStr(String key) {
        return properties.getProperty(key);
    }

    public static String getStr2(String key) {
        return properties.getProperty(key, key);
    }

    public static String getStr(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static boolean getBoolean(String key) {
        return Boolean.valueOf(Props.getStr(key));
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String str = Props.getStr(key);
        return str == null ? defaultValue : Boolean.valueOf(str);
    }

    public static int getInt(String key) {
        return Props.getInt(key, 0);
    }

    public static int getInt(String key, int defaultValue) {
        try {
            return Integer.valueOf(Props.getStr(key));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }
}

