/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.eop.api.internal.util;

import com.ailk.ecs.ssp.eop.api.internal.util.Base64;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class RsaKeyCreator {
    public static void main(String[] args) {
        try {
            System.out.println(RsaKeyCreator.doAction("rsa"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object doAction(String type) {
        Object ret = null;
        try {
            if ("appcode".equals(type)) {
                String s = UUID.randomUUID().toString();
                String appcode = String.valueOf(s.substring(0, 8)) + s.substring(9, 13) + s.substring(14, 18) + s.substring(19, 23) + s.substring(24);
                ret = appcode.toUpperCase();
            } else if ("aeskey".equals(type)) {
                KeyGenerator kgen = KeyGenerator.getInstance("AES");
                kgen.init(128);
                SecretKey skey = kgen.generateKey();
                byte[] raw = skey.getEncoded();
                ret = Base64.encodeToString(raw, false);
            } else if ("hmackey".equals(type)) {
                String algorithm = "HmacMD5";
                KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
                SecretKey secretKey = keyGenerator.generateKey();
                ret = Base64.encodeToString(secretKey.getEncoded(), false);
            } else if ("rsa".equals(type) || "dsa".equals(type)) {
                int keysize = 1024;
                if (keysize < 512 || keysize > 1024 || keysize % 64 != 0) {
                    keysize = 1024;
                }
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance(type.toUpperCase());
                keyGen.initialize(keysize);
                KeyPair keyPair = keyGen.generateKeyPair();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("pubkey", Base64.encodeToString(keyPair.getPublic().getEncoded(), false));
                hashMap.put("prikey", Base64.encodeToString(keyPair.getPrivate().getEncoded(), false));
                ret = hashMap;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

