/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.eop.api.internal.util;

import com.ailk.ecs.ssp.eop.api.internal.util.Base64;
import com.ailk.ecs.ssp.eop.api.internal.util.ByteUtils;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import sun.misc.BASE64Decoder;

public class RsaUtils {
    private static final String ALGORITHM = "RSA";
    private static final String RSA_ECB_PKCS1_PADDING = "RSA/ECB/PKCS1Padding";
    private static ThreadLocal<Cipher> rsaCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(RsaUtils.RSA_ECB_PKCS1_PADDING);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("getInstance Cipher Error!", e);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException("getInstance Cipher Error!", e);
            }
        }
    };

    public static String encrypt(String paramValue, String prikey) throws Exception {
        byte[] plainText = paramValue.getBytes();
        rsaCipher.get().init(1, RsaUtils.getPrivateKey(prikey));
        byte[] enBytes = rsaCipher.get().doFinal(plainText);
        return Base64.encodeToString(enBytes, false);
    }

    public static String encrypts(String paramValue, String pubkey) throws Exception {
        byte[] plainText = paramValue.getBytes();
        rsaCipher.get().init(1, RsaUtils.getPublicKey(pubkey));
        byte[] enBytes = rsaCipher.get().doFinal(plainText);
        return Base64.encodeToString(enBytes, false);
    }

    public static String decrypt(String paramValue, String pubkey) throws Exception {
        byte[] enBytes = Base64.decode(paramValue);
        rsaCipher.get().init(2, RsaUtils.getPublicKey(pubkey));
        byte[] deBytes = rsaCipher.get().doFinal(enBytes);
        return ByteUtils.toString(deBytes);
    }

    public static String decrypts(String paramValue, String prikey) throws Exception {
        byte[] enBytes = Base64.decode(paramValue);
        rsaCipher.get().init(2, RsaUtils.getPrivateKey(prikey));
        byte[] deBytes = rsaCipher.get().doFinal(enBytes);
        return ByteUtils.toString(deBytes);
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = new BASE64Decoder().decodeBuffer(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static PublicKey getPublicKey(String key) throws Exception {
        byte[] keyBytes = new BASE64Decoder().decodeBuffer(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static void main(String[] args) throws Exception {
        String pub = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCK8Sgr19FhDWTEAzelgA5vPs+3ymWUK3N8a+y2W76ruIkXhHbw31v2AMU1ZGlHjCVmL3CbqEQzY4ZI1vJX7ZL75SGEKBeubIUuccDY6GkyBabjlE8rJIe2+svxHkTgFEaNZColBk91VLY0Zpoez3KI+6tIh+J4cPNUlUuaVB1OgwIDAQAB";
        String pri = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAIrxKCvX0WENZMQDN6WADm8+z7fKZZQrc3xr7LZbvqu4iReEdvDfW/YAxTVkaUeMJWYvcJuoRDNjhkjW8lftkvvlIYQoF65shS5xwNjoaTIFpuOUTyskh7b6y/EeROAURo1kKiUGT3VUtjRmmh7Pcoj7q0iH4nhw81SVS5pUHU6DAgMBAAECgYAYGLbk06smb9I4BG7ULx9Rv8z6jQmM5vRCcd09yy+ITJrKD1kpcTNbuMp69g0kMXQTAss+07HwT6RsYYrqIPPKpTGuMxdsuHpACdBzaru45fSQPmjMdCzct5adp+548LE5p1+sxrXO0OCKhGVezK170nd7HTfu3xyxSvdCnGZ9UQJBAObh6DBTVRZaWLF8KUlF1RJlxBFJHRymi9pn82TVDw/Dp9rtml4aBJVGsO21UqNECaUsDnHTLYDopK6mAJtCPlUCQQCaDrPHtfAzMHREyNM6Eqi51QG2zcWp+QXoaaOS37zbBQdOvGz2cQw7u9YREFSprNeKUPk0CYZUpARH72V5xAF3AkAX2MNzolfKfEBm7I0THVxZjxtGMcgI+oa9Yzk3c+4fUbUXnqzwBT3t8SQ7GRxU8qUQY1GGnio4A09nHow3fQsVAkBRBN5jbzltklPzQLJlXh7B7FXEb58+bqo+uh++RFAr1w8qx0l+qaFHYNeJjc8YlL+eDEuipEezB7cApdP2H7CtAkEA2mHJUwCVKE89aaZzKghLTqyA8DWjMaEs1U6p4P19kTPafxrbCZALKm3PV5uUkUcyb12eJvtWjk8U7FuO1bOIdQ==";
        String mingwen = "1_20170517084414";
        String dd = RsaUtils.encrypts(mingwen, pub);
        System.out.println("\u660e\u6587\uff1a" + mingwen);
        System.out.println("\u5bc6\u6587\uff1a" + dd);
        String jiemi = RsaUtils.decrypts(dd, pri);
        System.out.println("\u89e3\u5bc6\uff1a" + jiemi);
    }
}

