/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.eop.api.internal.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Strings {
    public static final Pattern NUMERIC_PATTERN = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+$");
    public static final Pattern INTEGER_PATTERN = Pattern.compile("[-+]?([0-9]+)$");
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^([\\w-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([\\w-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$");
    private static final String SEPERATE_COMMA = ",";

    public static String dup(CharSequence cs, int num) {
        if (Strings.isEmpty(cs) || num <= 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(cs.length() * num);
        int i = 0;
        while (i < num) {
            sb.append(cs);
            ++i;
        }
        return sb.toString();
    }

    public static String dup(char c, int num) {
        if (c == '\u0000' || num < 1) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(num);
        int i = 0;
        while (i < num) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String capitalize(CharSequence s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return EMPTY;
        }
        char char0 = s.charAt(0);
        if (Character.isUpperCase(char0)) {
            return s.toString();
        }
        return new StringBuilder(len).append(Character.toUpperCase(char0)).append(s.subSequence(1, len)).toString();
    }

    public static String lowerFirst(CharSequence s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return EMPTY;
        }
        char c = s.charAt(0);
        if (Character.isLowerCase(c)) {
            return s.toString();
        }
        return new StringBuilder(len).append(Character.toLowerCase(c)).append(s.subSequence(1, len)).toString();
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equalsIgnoreCase(s2);
    }

    public static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static boolean startsWithChar(String s, char c) {
        return s != null ? (s.length() == 0 ? false : s.charAt(0) == c) : false;
    }

    public static boolean endsWithChar(String s, char c) {
        return s != null ? (s.length() == 0 ? false : s.charAt(s.length() - 1) == c) : false;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isBlank(CharSequence cs) {
        if (cs == null) {
            return true;
        }
        int length = cs.length();
        int i = 0;
        while (i < length) {
            if (!Character.isWhitespace(cs.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String trim(CharSequence cs) {
        int last;
        if (cs == null) {
            return null;
        }
        if (cs instanceof String) {
            return ((String)cs).trim();
        }
        int length = cs.length();
        if (length == 0) {
            return cs.toString();
        }
        int l = 0;
        int r = last = length - 1;
        while (l < length) {
            if (!Character.isWhitespace(cs.charAt(l))) break;
            ++l;
        }
        while (r > l) {
            if (!Character.isWhitespace(cs.charAt(r))) break;
            --r;
        }
        if (l > r) {
            return EMPTY;
        }
        if (l == 0 && r == last) {
            return cs.toString();
        }
        return cs.subSequence(l, r + 1).toString();
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return EMPTY;
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return EMPTY;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String join(Collection<String> list, String seperate) {
        return Strings.join(list, seperate, null, null);
    }

    public static String join(Collection<String> list, String seperate, String brace) {
        return Strings.join(list, seperate, brace, brace);
    }

    public static String join(Collection<String> list, String seperate, String prefix, String postfix) {
        if (list == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(256);
        for (String str : list) {
            if (builder.length() > 0) {
                builder.append(seperate);
            }
            if (prefix != null) {
                builder.append(prefix);
            }
            builder.append(str);
            if (postfix == null) continue;
            builder.append(postfix);
        }
        return builder.toString();
    }

    public static String join(String[] list, String seperate) {
        return Strings.join(list, seperate, null, null);
    }

    public static String join(String[] list, String seperate, String brace) {
        return Strings.join(list, seperate, brace, brace);
    }

    public static String join(String[] list, String seperate, String prefix, String postfix) {
        if (list == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(256);
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (builder.length() > 0) {
                builder.append(seperate);
            }
            if (prefix != null) {
                builder.append(prefix);
            }
            builder.append(str);
            if (postfix != null) {
                builder.append(postfix);
            }
            ++n2;
        }
        return builder.toString();
    }

    public static String[] split(String str) {
        return Strings.split(str, SEPERATE_COMMA, true);
    }

    public static String[] split(String str, String seperate, boolean bypassEmpty) {
        String subStr;
        ArrayList<String> arr = new ArrayList<String>();
        int startPos = 0;
        int indexOf = Strings.indexOf(str, seperate, startPos);
        while (indexOf >= 0) {
            subStr = Strings.substring(str, startPos, indexOf);
            if (!bypassEmpty || !Strings.isBlank(subStr)) {
                arr.add(subStr.trim());
            }
            startPos = indexOf + 1;
            indexOf = Strings.indexOf(str, seperate, startPos);
        }
        if (startPos <= (str == null ? -1 : str.length())) {
            subStr = Strings.substring(str, startPos);
            if (!bypassEmpty || !Strings.isBlank(subStr)) {
                arr.add(subStr.trim());
            }
        }
        return arr.toArray(new String[arr.size()]);
    }

    public static String repeat(String str, String seperate, int count) {
        StringBuilder sb = new StringBuilder();
        if (count > 0) {
            sb.append(str);
        }
        int i = 1;
        while (i < count) {
            sb.append(seperate).append(str);
            ++i;
        }
        return sb.toString();
    }

    public static String[] splitIgnoreBlank(String s) {
        return Strings.splitIgnoreBlank(s, SEPERATE_COMMA);
    }

    public static String[] splitIgnoreBlank(String s, String regex) {
        if (s == null) {
            return null;
        }
        String[] ss = s.split(regex);
        LinkedList<String> list = new LinkedList<String>();
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String st = stringArray[n2];
            if (!Strings.isBlank(st)) {
                list.add(Strings.trim(st));
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String fillDigit(int d, int width) {
        return Strings.alignRight(String.valueOf(d), width, '0');
    }

    public static String fillHex(int d, int width) {
        return Strings.alignRight(Integer.toHexString(d), width, '0');
    }

    public static String fillBinary(int d, int width) {
        return Strings.alignRight(Integer.toBinaryString(d), width, '0');
    }

    public static String toDigit(int d, int width) {
        return Strings.cutRight(String.valueOf(d), width, '0');
    }

    public static String toHex(int d, int width) {
        return Strings.cutRight(Integer.toHexString(d), width, '0');
    }

    public static String toBinary(int d, int width) {
        return Strings.cutRight(Integer.toBinaryString(d), width, '0');
    }

    public static String cutRight(String s, int width, char c) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == width) {
            return s;
        }
        if (len < width) {
            return String.valueOf(Strings.dup(c, width - len)) + s;
        }
        return s.substring(len - width, len);
    }

    public static String alignRight(CharSequence cs, int width, char c) {
        if (cs == null) {
            return null;
        }
        int len = cs.length();
        if (len >= width) {
            return cs.toString();
        }
        return Strings.dup(c, width - len) + cs;
    }

    public static String alignLeft(CharSequence cs, int width, char c) {
        if (cs == null) {
            return null;
        }
        int length = cs.length();
        if (length >= width) {
            return cs.toString();
        }
        return cs + Strings.dup(c, width - length);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isQuoteByIgnoreBlank(CharSequence cs, char lc, char rc) {
        if (cs == null) {
            return false;
        }
        len = cs.length();
        if (len < 2) {
            return false;
        }
        l = 0;
        r = last = len - 1;
        while (l < len) {
            if (!Character.isWhitespace(cs.charAt(l))) break;
            ++l;
        }
        if (cs.charAt(l) == lc) ** GOTO lbl16
        return false;
        while (Character.isWhitespace(cs.charAt(r))) {
            --r;
lbl16:
            // 2 sources

            if (r > l) continue;
        }
        return l < r && cs.charAt(r) == rc;
    }

    public static boolean isQuoteBy(CharSequence cs, char lc, char rc) {
        if (cs == null) {
            return false;
        }
        int length = cs.length();
        return length > 1 && cs.charAt(0) == lc && cs.charAt(length - 1) == rc;
    }

    public static int maxLength(Collection<? extends CharSequence> coll) {
        int re = 0;
        if (coll != null) {
            for (CharSequence charSequence : coll) {
                if (charSequence == null) continue;
                re = Math.max(re, charSequence.length());
            }
        }
        return re;
    }

    public static <T extends CharSequence> int maxLength(T[] array) {
        int re = 0;
        if (array != null) {
            T[] TArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                T s = TArray[n2];
                if (s != null) {
                    re = Math.max(re, s.length());
                }
                ++n2;
            }
        }
        return re;
    }

    public static String sNull(Object obj) {
        return Strings.sNull(obj, EMPTY);
    }

    public static String sNull(Object obj, String def) {
        return obj != null ? obj.toString() : def;
    }

    public static String sBlank(Object obj) {
        return Strings.sBlank(obj, EMPTY);
    }

    public static String sBlank(Object obj, String def) {
        if (obj == null) {
            return def;
        }
        String s = obj.toString();
        return Strings.isBlank(s) ? def : s;
    }

    public static String removeFirst(CharSequence str) {
        if (str == null) {
            return null;
        }
        if (str.length() > 1) {
            return str.subSequence(1, str.length()).toString();
        }
        return EMPTY;
    }

    public static String removeFirst(String str, char c) {
        return Strings.isEmpty(str) || c != str.charAt(0) ? str : str.substring(1);
    }

    public static boolean isin(String[] ss, String s) {
        if (ss == null || ss.length == 0 || Strings.isBlank(s)) {
            return false;
        }
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            if (s.equals(w)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static synchronized boolean isEmail(CharSequence input) {
        return EMAIL_PATTERN.matcher(input).matches();
    }

    public static String upperWord(CharSequence s, char c) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch == c) {
                do {
                    if (++i < len) continue;
                    return sb.toString();
                } while ((ch = s.charAt(i)) == c);
                sb.append(Character.toUpperCase(ch));
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String substringBefore(String str, String separator) {
        if (Strings.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfter(String str, String separator) {
        if (Strings.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static boolean startsWith(String str, String prefix) {
        return Strings.startsWith(str, prefix, false);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return Strings.startsWith(str, prefix, true);
    }

    private static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWith(String str, String suffix) {
        return Strings.endsWith(str, suffix, false);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return Strings.endsWith(str, suffix, true);
    }

    private static boolean endsWith(String str, String suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static int indexOf(String str, char searchChar) {
        if (Strings.isEmpty(str)) {
            return -1;
        }
        return str.indexOf(searchChar);
    }

    public static int indexOf(String str, char searchChar, int startPos) {
        if (Strings.isEmpty(str)) {
            return -1;
        }
        return str.indexOf(searchChar, startPos);
    }

    public static int indexOf(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return str.indexOf(searchStr);
    }

    public static int ordinalIndexOf(String str, String searchStr, int ordinal) {
        return Strings.ordinalIndexOf(str, searchStr, ordinal, false);
    }

    private static int ordinalIndexOf(String str, String searchStr, int ordinal, boolean lastIndex) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return lastIndex ? str.length() : 0;
        }
        int found = 0;
        int index = lastIndex ? str.length() : -1;
        do {
            if ((index = lastIndex ? str.lastIndexOf(searchStr, index - 1) : str.indexOf(searchStr, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static int indexOf(String str, String searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (searchStr.length() == 0 && startPos >= str.length()) {
            return str.length();
        }
        return str.indexOf(searchStr, startPos);
    }

    public static int indexOfIgnoreCase(String str, String searchStr) {
        return Strings.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(String str, String searchStr, int startPos) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (startPos > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        int i = startPos;
        while (i < endLimit) {
            if (str.regionMatches(true, i, searchStr, 0, searchStr.length())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(String str, char searchChar) {
        if (Strings.isEmpty(str)) {
            return -1;
        }
        return str.lastIndexOf(searchChar);
    }

    public static int lastIndexOf(String str, char searchChar, int startPos) {
        if (Strings.isEmpty(str)) {
            return -1;
        }
        return str.lastIndexOf(searchChar, startPos);
    }

    public static int lastIndexOf(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return str.lastIndexOf(searchStr);
    }

    public static int lastIndexOf(String str, String searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return str.lastIndexOf(searchStr, startPos);
    }

    public static int lastIndexOfIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return Strings.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(String str, String searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos > str.length() - searchStr.length()) {
            startPos = str.length() - searchStr.length();
        }
        if (startPos < 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        int i = startPos;
        while (i >= 0) {
            if (str.regionMatches(true, i, searchStr, 0, searchStr.length())) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        int j = 0;
        while (j < substring.length()) {
            int i = index + j;
            if (i >= str.length() || str.charAt(i) != substring.charAt(j)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static String substringBetween(String str, String tag) {
        return Strings.substringBetween(str, tag, tag);
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String uncapitalize(String str) {
        if (str == null) {
            return str;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static boolean isNumeric(String string) {
        return NUMERIC_PATTERN.matcher(string).matches();
    }

    public static boolean isInteger(String string) {
        if (Strings.isEmpty(string)) {
            return false;
        }
        Matcher matcher = INTEGER_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String number = matcher.group(1);
        String maxValue = "2147483647";
        if (number.length() > maxValue.length()) {
            return false;
        }
        return Strings.alignRight(number, maxValue.length(), '0').compareTo(maxValue) <= 0;
    }

    public static boolean isLong(String string) {
        Matcher matcher = INTEGER_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String number = matcher.group(1);
        String maxValue = "9223372036854775807";
        if (number.length() > maxValue.length()) {
            return false;
        }
        return Strings.alignRight(number, maxValue.length(), '0').compareTo(maxValue) <= 0;
    }

    public static String substringBeforeLast(String str, String separator) {
        if (Strings.isEmpty(str) || Strings.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfterLast(String str, String separator) {
        if (Strings.isEmpty(str)) {
            return str;
        }
        if (Strings.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String replaceOnce(String text, String searchString, String replacement) {
        return Strings.replace(text, searchString, replacement, 1);
    }

    public static String replace(String text, String searchString, String replacement) {
        return Strings.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (Strings.isEmpty(text) || Strings.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        return Strings.replaceEach(text, searchList, replacementList, false, 0);
    }

    public static String replaceEachRepeatedly(String text, String[] searchList, String[] replacementList) {
        int timeToLive = searchList == null ? 0 : searchList.length;
        return Strings.replaceEach(text, searchList, replacementList, true, timeToLive);
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList, boolean repeat, int timeToLive) {
        if (text == null || text.length() == 0 || searchList == null || searchList.length == 0 || replacementList == null || replacementList.length == 0) {
            return text;
        }
        if (timeToLive < 0) {
            throw new IllegalStateException("Aborting to protect against StackOverflowError - output of one loop is the input of another");
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        int tempIndex = -1;
        int i = 0;
        while (i < searchLength) {
            if (!noMoreMatchesForReplIndex[i] && searchList[i] != null && searchList[i].length() != 0 && replacementList[i] != null) {
                tempIndex = text.indexOf(searchList[i]);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                } else if (textIndex == -1 || tempIndex < textIndex) {
                    textIndex = tempIndex;
                    replaceIndex = i;
                }
            }
            ++i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        int i2 = 0;
        while (i2 < searchList.length) {
            int greater;
            if (searchList[i2] != null && replacementList[i2] != null && (greater = replacementList[i2].length() - searchList[i2].length()) > 0) {
                increase += 3 * greater;
            }
            ++i2;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i3 = start;
            while (i3 < textIndex) {
                buf.append(text.charAt(i3));
                ++i3;
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            tempIndex = -1;
            i3 = 0;
            while (i3 < searchLength) {
                if (!noMoreMatchesForReplIndex[i3] && searchList[i3] != null && searchList[i3].length() != 0 && replacementList[i3] != null) {
                    tempIndex = text.indexOf(searchList[i3], start);
                    if (tempIndex == -1) {
                        noMoreMatchesForReplIndex[i3] = true;
                    } else if (textIndex == -1 || tempIndex < textIndex) {
                        textIndex = tempIndex;
                        replaceIndex = i3;
                    }
                }
                ++i3;
            }
        }
        int textLength = text.length();
        int i4 = start;
        while (i4 < textLength) {
            buf.append(text.charAt(i4));
            ++i4;
        }
        String result = buf.toString();
        if (!repeat) {
            return result;
        }
        return Strings.replaceEach(result, searchList, replacementList, repeat, timeToLive - 1);
    }

    public static String replaceChars(String str, char searchChar, char replaceChar) {
        if (str == null) {
            return null;
        }
        return str.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        if (Strings.isEmpty(str) || Strings.isEmpty(searchChars)) {
            return str;
        }
        if (replaceChars == null) {
            replaceChars = EMPTY;
        }
        boolean modified = false;
        int replaceCharsLength = replaceChars.length();
        int strLength = str.length();
        StringBuilder buf = new StringBuilder(strLength);
        int i = 0;
        while (i < strLength) {
            char ch = str.charAt(i);
            int index = searchChars.indexOf(ch);
            if (index >= 0) {
                modified = true;
                if (index < replaceCharsLength) {
                    buf.append(replaceChars.charAt(index));
                }
            } else {
                buf.append(ch);
            }
            ++i;
        }
        if (modified) {
            return buf.toString();
        }
        return str;
    }

    public static String defaultString(String str) {
        return str == null ? EMPTY : str;
    }

    public static String defaultString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static <T extends CharSequence> T defaultIfBlank(T str, T defaultStr) {
        return Strings.isBlank(str) ? defaultStr : str;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, T defaultStr) {
        return Strings.isEmpty(str) ? defaultStr : str;
    }

    public static String decode(String str, String expr) {
        String[] arr = expr.split(SEPERATE_COMMA);
        String temp = str;
        if (temp == null) {
            temp = "null";
        }
        int i = 0;
        while (i < arr.length - 1) {
            if (arr[i].equals(str)) {
                return arr[i + 1];
            }
            i += 2;
        }
        if (arr.length - i == 1) {
            return arr[i];
        }
        return temp;
    }

    public static String substrbGBK(String input, int n) {
        return Strings.substrb(input, n, "GBK");
    }

    public static String substrb(String input, int n, String charsetName) {
        byte[] bytes;
        if (Strings.isEmpty(input)) {
            return input;
        }
        if (n <= 0) {
            return EMPTY;
        }
        try {
            bytes = input.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (n >= bytes.length) {
            return input;
        }
        byte[] data = new byte[n];
        int x = 0;
        int y = 0;
        while (x < n) {
            int length = Character.toString(input.charAt(y)).getBytes().length;
            if (length > 1) {
                if (x >= n - 1) break;
                data[x] = bytes[x];
                data[x + 1] = bytes[x + 1];
                x += 2;
                ++y;
                continue;
            }
            data[x] = bytes[x];
            ++x;
            ++y;
        }
        try {
            return new String(data, 0, x, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> parseMapStr(String mapString) {
        return Strings.parseMapStr(mapString, SEPERATE_COMMA, ":");
    }

    public static Map<String, String> parseMapStr(String mapString, String firstSeperator, String secondSeperator) {
        String mappedDesc = Strings.substringBetween(mapString, "{", "}");
        if (Strings.isEmpty(mappedDesc)) {
            return null;
        }
        String[] someMappedDescs = Strings.split(mappedDesc, firstSeperator, true);
        HashMap<String, String> descMap = new HashMap<String, String>(someMappedDescs.length);
        String[] stringArray = someMappedDescs;
        int n = someMappedDescs.length;
        int n2 = 0;
        while (n2 < n) {
            String oneMappedDesc = stringArray[n2];
            int indexOf = oneMappedDesc.indexOf(secondSeperator);
            if (indexOf < 0) {
                descMap.put(oneMappedDesc, EMPTY);
            } else if (indexOf > 0) {
                String key = oneMappedDesc.substring(0, indexOf);
                String val = Strings.substring(oneMappedDesc, indexOf + secondSeperator.length());
                if (!Strings.isBlank(key)) {
                    descMap.put(key.trim(), Strings.trim(val));
                }
            }
            ++n2;
        }
        return descMap;
    }
}

