/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.eop.api.internal.util;

import com.ailk.ecs.ssp.eop.api.internal.util.EopLogger;
import com.ailk.ecs.ssp.eop.api.internal.util.HttpRsp;
import com.ailk.ecs.ssp.eop.api.internal.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebUtils {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final Logger logger = LoggerFactory.getLogger((String)"EOP_LOG");

    public static HttpRsp doPost(Proxy proxy, String proxyAuthorization, String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        return WebUtils.doPost(proxy, proxyAuthorization, url, params, DEFAULT_CHARSET, connectTimeout, readTimeout);
    }

    public static HttpRsp doPost(Proxy proxy, String proxyAuthorization, String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        EopLogger.info("[url={}][request={}]", url, query);
        HttpRsp httpRsp = new HttpRsp();
        httpRsp.setQuery(query);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        WebUtils.doPost(httpRsp, proxy, proxyAuthorization, url, ctype, content, connectTimeout, readTimeout);
        EopLogger.info("[url={}][response={}]", url, httpRsp.getContent());
        return httpRsp;
    }

    public static void doPost(HttpRsp httpRsp, Proxy proxy, String proxyAuthorization, String url, String ctype, byte[] content, int connectTimeout, int readTimeout) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            try {
                conn = WebUtils.getConnection(proxy, proxyAuthorization, new URL(url), METHOD_POST, ctype);
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
            }
            catch (IOException e) {
                Map<String, String> map = WebUtils.getParamsFromUrl(url);
                EopLogger.logCommError((Exception)e, url, map.get("app_key"), map.get("method"), content);
                throw e;
            }
            try {
                out = conn.getOutputStream();
                out.write(content);
                String rsp = WebUtils.getResponseAsString(conn);
                String contentType = conn.getContentType();
                httpRsp.setContentType(contentType);
                httpRsp.setContent(rsp);
            }
            catch (IOException e) {
                Map<String, String> map = WebUtils.getParamsFromUrl(url);
                EopLogger.logCommError((Exception)e, conn, map.get("app_key"), map.get("method"), content);
                throw e;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static HttpURLConnection getConnection(Proxy proxy, String proxyAuthorization, URL url, String method, String ctype) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)(proxy == null ? url.openConnection() : url.openConnection(proxy));
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html");
        conn.setRequestProperty("User-Agent", "EOP-sdk-java");
        conn.setRequestProperty("Content-Type", ctype);
        if (proxyAuthorization != null && proxyAuthorization.length() > 0) {
            conn.setRequestProperty("Proxy-Authorization", "Basic " + proxyAuthorization);
        }
        return conn;
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(URLEncoder.encode(name, charset)).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = WebUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return WebUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = WebUtils.getStreamAsString(es, charset);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(String.valueOf(conn.getResponseCode()) + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            String[] stringArray = params = ctype.split(";");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                if ((param = param.trim()).startsWith("charset")) {
                    String[] pair = param.split("=", 2);
                    if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                    charset = pair[1].trim();
                    break;
                }
                ++n2;
            }
        }
        return charset;
    }

    public static String decode(String value) {
        return WebUtils.decode(value, DEFAULT_CHARSET);
    }

    public static String encode(String value) {
        return WebUtils.encode(value, DEFAULT_CHARSET);
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static Map<String, String> getParamsFromUrl(String url) {
        Map<Object, Object> map = null;
        if (url != null && url.indexOf(63) != -1) {
            map = WebUtils.splitUrlQuery(url.substring(url.indexOf(63) + 1));
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            String[] stringArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] param = pair.split("=", 2);
                if (param != null && param.length == 2) {
                    result.put(param[0], param[1]);
                }
                ++n2;
            }
        }
        return result;
    }
}

