/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.eop.api.internal.util;

import com.ailk.ecs.ssp.eop.api.ApiException;
import com.ailk.ecs.ssp.eop.api.internal.util.StringUtils;
import com.ailk.ecs.ssp.eop.api.internal.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private static final String XMLNS_XSI = "xmlns:xsi";
    private static final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    private static final String LOGIC_YES = "yes";
    private static final String DEFAULT_ENCODE = "UTF-8";
    private static final String REG_INVALID_CHARS = "&#\\d+;";

    public static List<Element> getElementsChildren(Element e) {
        NodeList nodes = e.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        ArrayList<Element> ret = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                ret.add((Element)node);
            }
            ++i;
        }
        return ret;
    }

    public static Map<String, Object> dom2Map(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Element> childrenElements = XmlUtils.getElementsChildren(e);
        if (childrenElements == null || childrenElements.size() == 0) {
            XmlUtils.putMap(map, e.getTagName(), XmlUtils.getElementValue(e));
            return map;
        }
        for (Element child : childrenElements) {
            List<Element> elements = XmlUtils.getElementsChildren(child);
            if (elements == null || elements.size() == 0) {
                XmlUtils.putMap(map, child.getTagName(), XmlUtils.getElementValue(child));
                continue;
            }
            XmlUtils.putMap(map, child.getTagName(), XmlUtils.dom2Map(child));
        }
        return map;
    }

    public static boolean isArrayFormat(List<Element> elementsChildren) {
        if (elementsChildren.size() == 1) {
            return false;
        }
        Element first = elementsChildren.get(0);
        for (Element element : elementsChildren) {
            if (element.getTagName().equals(first.getTagName())) continue;
            return false;
        }
        return true;
    }

    public static void putMap(Map<String, Object> map, String key, Object value) {
        Object keyValue = map.get(key);
        if (keyValue == null) {
            map.put(key, value);
        } else if (keyValue instanceof List) {
            List arrayList = (List)keyValue;
            arrayList.add(value);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(keyValue);
            arrayList.add(value);
            map.put(key, arrayList);
        }
    }

    public static Document newDocument() throws ApiException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new ApiException(e);
        }
        return doc;
    }

    public static Document getDocument(File file) throws ApiException {
        InputStream in = XmlUtils.getInputStream(file);
        return XmlUtils.getDocument(in);
    }

    public static boolean isXmlTagStart(String str) {
        return Strings.startsWith(Strings.trim(str), "<");
    }

    public static Document getDocument(InputStream in) throws ApiException {
        Document doc = null;
        try {
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                doc = builder.parse(in);
            }
            catch (ParserConfigurationException e) {
                throw new ApiException(e);
            }
            catch (SAXException e) {
                throw new ApiException("XML_PARSE_ERROR", e);
            }
            catch (IOException e) {
                throw new ApiException("XML_READ_ERROR", e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return doc;
    }

    public static Element createRootElement(String tagName) throws ApiException {
        Document doc = XmlUtils.newDocument();
        Element root = doc.createElement(tagName);
        doc.appendChild(root);
        return root;
    }

    public static Element getRootElementFromStream(InputStream in) throws ApiException {
        return XmlUtils.getDocument(in).getDocumentElement();
    }

    public static Element getRootElementFromFile(File file) throws ApiException {
        return XmlUtils.getDocument(file).getDocumentElement();
    }

    public static Element getRootElementFromString(String payload) throws ApiException {
        if (payload == null || payload.trim().length() < 1) {
            throw new ApiException("XML_PAYLOAD_EMPTY");
        }
        byte[] bytes = null;
        try {
            payload = StringUtils.stripNonValidXMLCharacters(payload);
            bytes = payload.getBytes(DEFAULT_ENCODE);
        }
        catch (UnsupportedEncodingException e) {
            throw new ApiException("XML_ENCODE_ERROR", e);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return XmlUtils.getDocument(in).getDocumentElement();
    }

    public static List<Element> getElements(Element parent, String tagName) {
        NodeList nodes = parent.getElementsByTagName(tagName);
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                elements.add((Element)node);
            }
            ++i;
        }
        return elements;
    }

    public static Element getElement(Element parent, String tagName) {
        List<Element> children = XmlUtils.getElements(parent, tagName);
        if (children.isEmpty()) {
            return null;
        }
        return children.get(0);
    }

    public static List<Element> getChildElements(Element parent, String tagName) {
        NodeList nodes = parent.getElementsByTagName(tagName);
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element && node.getParentNode() == parent) {
                elements.add((Element)node);
            }
            ++i;
        }
        return elements;
    }

    public static Element getChildElement(Element parent, String tagName) {
        List<Element> children = XmlUtils.getChildElements(parent, tagName);
        if (children.isEmpty()) {
            return null;
        }
        return children.get(0);
    }

    public static String getElementValue(Element parent, String tagName) {
        NodeList nodes;
        Element element = XmlUtils.getChildElement(parent, tagName);
        if (element != null && (nodes = element.getChildNodes()) != null && nodes.getLength() > 0) {
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node instanceof Text) {
                    return ((Text)node).getData();
                }
                ++i;
            }
        }
        return null;
    }

    public static String getElementValue(Element element) {
        NodeList nodes;
        if (element != null && (nodes = element.getChildNodes()) != null && nodes.getLength() > 0) {
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node instanceof Text) {
                    return ((Text)node).getData();
                }
                ++i;
            }
        }
        return null;
    }

    public static Element appendElement(Element parent, String tagName) {
        Element child = parent.getOwnerDocument().createElement(tagName);
        parent.appendChild(child);
        return child;
    }

    public static Element appendElement(Element parent, String tagName, String value) {
        Element child = XmlUtils.appendElement(parent, tagName);
        child.appendChild(child.getOwnerDocument().createTextNode(value));
        return child;
    }

    public static void appendElement(Element parent, Element child) {
        Node tmp = parent.getOwnerDocument().importNode(child, true);
        parent.appendChild(tmp);
    }

    public static Element appendCDATAElement(Element parent, String tagName, String value) {
        Element child = XmlUtils.appendElement(parent, tagName);
        if (value == null) {
            value = "";
        }
        CDATASection cdata = child.getOwnerDocument().createCDATASection(value);
        child.appendChild(cdata);
        return child;
    }

    public static String childNodeToString(Node node) throws ApiException {
        String payload = null;
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            Properties props = tf.getOutputProperties();
            props.setProperty("omit-xml-declaration", LOGIC_YES);
            tf.setOutputProperties(props);
            StringWriter writer = new StringWriter();
            tf.transform(new DOMSource(node), new StreamResult(writer));
            payload = writer.toString();
            payload = payload.replaceAll(REG_INVALID_CHARS, " ");
        }
        catch (TransformerException e) {
            throw new ApiException("XML_TRANSFORM_ERROR", e);
        }
        return payload;
    }

    public static String nodeToString(Node node) throws ApiException {
        String payload = null;
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            Properties props = tf.getOutputProperties();
            props.setProperty("indent", LOGIC_YES);
            props.setProperty("encoding", DEFAULT_ENCODE);
            tf.setOutputProperties(props);
            StringWriter writer = new StringWriter();
            tf.transform(new DOMSource(node), new StreamResult(writer));
            payload = writer.toString();
            payload = payload.replaceAll(REG_INVALID_CHARS, " ");
        }
        catch (TransformerException e) {
            throw new ApiException("XML_TRANSFORM_ERROR", e);
        }
        return payload;
    }

    public static String xmlToString(File file) throws ApiException {
        Element root = XmlUtils.getRootElementFromFile(file);
        return XmlUtils.nodeToString(root);
    }

    public static String xmlToString(InputStream in) throws ApiException {
        Element root = XmlUtils.getRootElementFromStream(in);
        return XmlUtils.nodeToString(root);
    }

    public static void saveToXml(Node doc, File file) throws ApiException {
        OutputStream out = null;
        try {
            try {
                Transformer tf = TransformerFactory.newInstance().newTransformer();
                Properties props = tf.getOutputProperties();
                props.setProperty("method", "xml");
                props.setProperty("indent", LOGIC_YES);
                tf.setOutputProperties(props);
                DOMSource dom = new DOMSource(doc);
                out = XmlUtils.getOutputStream(file);
                StreamResult result = new StreamResult(out);
                tf.transform(dom, result);
            }
            catch (TransformerException e) {
                throw new ApiException("XML_TRANSFORM_ERROR", e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void validateXml(Node doc, File schemaFile) throws ApiException {
        XmlUtils.validateXml(doc, XmlUtils.getInputStream(schemaFile));
    }

    public static void validateXml(Node doc, InputStream schemaStream) throws ApiException {
        try {
            try {
                StreamSource source = new StreamSource(schemaStream);
                Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(source);
                Validator validator = schema.newValidator();
                validator.validate(new DOMSource(doc));
            }
            catch (SAXException e) {
                throw new ApiException("XML_VALIDATE_ERROR", e);
            }
            catch (IOException e) {
                throw new ApiException("XML_READ_ERROR", e);
            }
        }
        finally {
            if (schemaStream != null) {
                try {
                    schemaStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String xmlToHtml(String payload, File xsltFile) throws ApiException {
        String result = null;
        try {
            StreamSource template = new StreamSource(xsltFile);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(template);
            Properties props = transformer.getOutputProperties();
            props.setProperty("omit-xml-declaration", LOGIC_YES);
            transformer.setOutputProperties(props);
            StreamSource source = new StreamSource(new StringReader(payload));
            StreamResult sr = new StreamResult(new StringWriter());
            transformer.transform(source, sr);
            result = sr.getWriter().toString();
        }
        catch (TransformerException e) {
            throw new ApiException("XML_TRANSFORM_ERROR", e);
        }
        return result;
    }

    public static void setNamespace(Element element, String namespace, String schemaLocation) {
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespace);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", XMLNS_XSI, "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", XSI_SCHEMA_LOCATION, schemaLocation);
    }

    public static String encodeXml(String payload) throws ApiException {
        Element root = XmlUtils.createRootElement("xml");
        root.appendChild(root.getOwnerDocument().createTextNode(payload));
        return XmlUtils.childNodeToString(root.getFirstChild());
    }

    private static InputStream getInputStream(File file) throws ApiException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ApiException("FILE_NOT_FOUND", e);
        }
        return in;
    }

    private static OutputStream getOutputStream(File file) throws ApiException {
        FileOutputStream in = null;
        try {
            in = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ApiException("FILE_NOT_FOUND", e);
        }
        return in;
    }
}

