/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.network.clientupstream;

import com.ailk.ecs.ssp.network.clientupstream.SspServiceServer;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckServerStatus
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckServerStatus.class);
    private SspServiceServer server;
    private Socket socket;
    private int timeout = 1000;

    public CheckServerStatus(SspServiceServer server) {
        this.server = server;
    }

    @Override
    public void run() {
        long _downCount;
        this.checkUp();
        long _upCount = this.server.upCount.get();
        if (_upCount > 2L && !this.server.up.get()) {
            this.server.up.set(true);
            this.server.downCount.set(0L);
            System.out.println("server: " + this.server.getEndPoint() + " became active.");
        }
        if ((_downCount = this.server.downCount.get()) > 5L && this.server.up.get()) {
            this.server.up.set(false);
            this.server.upCount.set(0L);
            System.out.println("server: " + this.server.getEndPoint() + " became inactive.");
        }
    }

    private boolean checkUp() {
        try {
            this.socket = new Socket();
            this.socket.setReuseAddress(true);
            this.socket.setKeepAlive(true);
            this.socket.setTcpNoDelay(true);
            this.socket.setSoLinger(true, 0);
            this.socket.connect(new InetSocketAddress(this.server.getIp(), (int)this.server.getPort()), this.timeout);
            this.socket.setSoTimeout(this.timeout);
            this.socket.close();
            this.server.upCount.incrementAndGet();
            return true;
        }
        catch (Exception e) {
            LOGGER.error(String.valueOf(this.server.getEndPoint()) + " check status error: ", (Throwable)e);
            this.server.downCount.incrementAndGet();
            return false;
        }
    }
}

