/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.network.clientupstream;

import com.ailk.ecs.ssp.network.clientupstream.CheckServerStatus;
import com.ailk.ecs.ssp.network.clientupstream.ScheduledThreadPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SspServiceServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SspServiceServer.class);
    private String endPoint;
    private String ip;
    private Integer port;
    AtomicLong upCount = new AtomicLong(0L);
    AtomicLong downCount = new AtomicLong(0L);
    AtomicBoolean up = new AtomicBoolean(true);

    public SspServiceServer(String endPoint) {
        this.endPoint = endPoint;
        Pattern p = Pattern.compile("http\\://(\\d+\\.\\d+\\.\\d+\\.\\d+)\\:(\\d+)/(ssp\\-gateway\\-release)$");
        Matcher m = p.matcher(endPoint);
        if (!m.find()) {
            this.up.set(false);
            LOGGER.warn("incorrect url(" + endPoint + "), please check it.");
            return;
        }
        this.ip = m.group(1);
        this.port = Integer.parseInt(m.group(2));
        ScheduledThreadPool.scheduleAtFixedRate(new CheckServerStatus(this), 0L, 1L, TimeUnit.SECONDS);
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public String getIp() {
        return this.ip;
    }

    public Integer getPort() {
        return this.port;
    }
}

