/*
 * Decompiled with CFR 0.152.
 */
package com.ailk.ecs.ssp.network.clientupstream;

import com.ailk.ecs.ssp.network.clientupstream.SspServiceServer;
import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SspServiceUpstream {
    private static final Logger LOGGER = LoggerFactory.getLogger(SspServiceUpstream.class);
    private List<SspServiceServer> actives = new CopyOnWriteArrayList<SspServiceServer>();
    private List<SspServiceServer> inactives = new ArrayList<SspServiceServer>();
    private static LoadingCache<String, SspServiceServer> cacheServers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, SspServiceServer>(){

        public SspServiceServer load(String key) {
            return new SspServiceServer(key);
        }
    });
    private AtomicLong count = new AtomicLong(0L);

    public SspServiceUpstream(String urls) {
        List<String> urlList = Arrays.asList(urls.split(","));
        ArrayList<SspServiceServer> _actives = new ArrayList<SspServiceServer>();
        ArrayList<SspServiceServer> _inactives = new ArrayList<SspServiceServer>();
        for (String key : urlList) {
            SspServiceServer server = (SspServiceServer)cacheServers.getUnchecked((Object)key);
            if (server == null) continue;
            if (server.up.get()) {
                _actives.add(server);
                continue;
            }
            _inactives.add(server);
        }
        this.actives.clear();
        this.actives.addAll(_actives);
        this.inactives.clear();
        this.inactives.addAll(_inactives);
        new WebServiceUpstreamCheck().start();
    }

    public String getEndPoint() {
        int size = this.actives.size();
        if (size == 0) {
            throw new RuntimeException("for servers" + JSON.toJSONString(this.actives) + JSON.toJSONString(this.inactives) + " are Not Available! ");
        }
        if (size == 1) {
            return this.actives.get(0).getEndPoint();
        }
        long current = this.count.getAndIncrement();
        try {
            SspServiceServer redisServer = this.actives.get((int)(current % (long)size));
            return redisServer.getEndPoint();
        }
        catch (Exception e) {
            size = this.actives.size();
            if (size == 0) {
                throw new RuntimeException("for servers" + JSON.toJSONString(this.actives) + JSON.toJSONString(this.inactives) + " are Not Available! ");
            }
            return this.actives.get(0).getEndPoint();
        }
    }

    public void downIncrease(String key) {
        ((SspServiceServer)SspServiceUpstream.cacheServers.getUnchecked((Object)key)).downCount.incrementAndGet();
    }

    class WebServiceUpstreamCheck
    extends Thread {
        WebServiceUpstreamCheck() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("sspservice upstream check error: ", (Throwable)e);
                }
                ArrayList<SspServiceServer> _actives = new ArrayList<SspServiceServer>();
                ArrayList<SspServiceServer> _inactives = new ArrayList<SspServiceServer>();
                boolean toInactive = false;
                boolean toActive = false;
                for (SspServiceServer redisServer : SspServiceUpstream.this.actives) {
                    if (redisServer.up.get()) {
                        _actives.add(redisServer);
                        continue;
                    }
                    _inactives.add(redisServer);
                    if (toInactive) continue;
                    toInactive = true;
                }
                for (SspServiceServer redisServer : SspServiceUpstream.this.inactives) {
                    if (redisServer.up.get()) {
                        _actives.add(redisServer);
                        if (toActive) continue;
                        toActive = true;
                        continue;
                    }
                    _inactives.add(redisServer);
                }
                if (!toInactive && !toActive) continue;
                SspServiceUpstream.this.actives.clear();
                SspServiceUpstream.this.actives.addAll(_actives);
                SspServiceUpstream.this.inactives.clear();
                SspServiceUpstream.this.inactives.addAll(_inactives);
                LOGGER.info("redis upstream status change.");
            }
        }
    }
}

