/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.cache;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.model.request.ConfigRequest;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class GroupVersionCache {
    private static ConfigRequest CONFIG;

    private GroupVersionCache() {
    }

    public static void setConfig(ConfigRequest config) {
        CONFIG = config;
    }

    public static Integer getVersion() {
        if (Objects.isNull(CONFIG)) {
            return 0;
        }
        return CONFIG.getVersion();
    }

    public static long getDdl(String sceneName) {
        if (Objects.isNull(CONFIG)) {
            return 60000L;
        }
        List sceneList = CONFIG.getSceneList();
        if (CollUtil.isEmpty((Collection)sceneList)) {
            return 60000L;
        }
        for (ConfigRequest.Scene scene : sceneList) {
            if (!scene.getSceneName().equals(sceneName)) continue;
            return scene.getDdl();
        }
        return 60000L;
    }

    public static ConfigRequest.Notify getRetryNotifyAttribute(Integer notifyScene) {
        List notifyList = CONFIG.getNotifyList();
        if (CollUtil.isNotEmpty((Collection)notifyList)) {
            for (ConfigRequest.Notify notify : notifyList) {
                if (!Objects.nonNull(notify.getRetryNotifyScene()) || !notify.getRetryNotifyScene().equals(notifyScene)) continue;
                return notify;
            }
        }
        return null;
    }

    public static ConfigRequest.Notify getJobNotifyAttribute(Integer notifyScene) {
        List notifyList = CONFIG.getNotifyList();
        if (CollUtil.isNotEmpty((Collection)notifyList)) {
            for (ConfigRequest.Notify notify : notifyList) {
                if (!Objects.nonNull(notify.getJobNotifyScene()) || !notify.getJobNotifyScene().equals(notifyScene)) continue;
                return notify;
            }
        }
        return null;
    }
}

