/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.supports.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.util.ServiceLoaderUtil;
import com.aizuda.snailjob.client.common.HandlerInterceptor;
import com.aizuda.snailjob.client.common.cache.EndPointInfoCache;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.common.rpc.client.RequestMethod;
import com.aizuda.snailjob.client.common.rpc.supports.handler.grpc.GrpcRequest;
import com.aizuda.snailjob.client.common.rpc.supports.http.HttpRequest;
import com.aizuda.snailjob.client.common.rpc.supports.http.HttpResponse;
import com.aizuda.snailjob.client.common.rpc.supports.scan.EndPointInfo;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.grpc.auto.Metadata;
import com.aizuda.snailjob.common.core.grpc.auto.SnailJobGrpcRequest;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class SnailDispatcherRequestHandler {
    private final SnailJobProperties snailJobProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SnailJobRpcResult dispatch(GrpcRequest request) {
        SnailJobRpcResult snailJobRpcResult;
        Throwable e;
        Result resultObj;
        EndPointInfo endPointInfo;
        List<HandlerInterceptor> handlerInterceptors;
        HttpResponse httpResponse;
        HttpRequest httpRequest;
        SnailJobRpcResult snailJobRpcResult2;
        block19: {
            snailJobRpcResult2 = new SnailJobRpcResult();
            httpRequest = request.getHttpRequest();
            httpResponse = request.getHttpResponse();
            handlerInterceptors = SnailDispatcherRequestHandler.handlerInterceptors();
            SnailJobGrpcRequest snailJobRequest = request.getSnailJobRequest();
            endPointInfo = null;
            resultObj = null;
            e = null;
            try {
                Metadata metadata = snailJobRequest.getMetadata();
                Map headersMap = metadata.getHeadersMap();
                String snailJobAuth = (String)headersMap.get("SJ-TOKEN");
                String configToken = Optional.ofNullable(this.snailJobProperties.getToken()).orElse("SJ_Wyz3dmsdbDOkDujOTSSoBjGQP1BMsVnj");
                if (!configToken.equals(snailJobAuth)) {
                    throw new SnailJobClientException("Authentication failed. [Please check if the configured Token is correct]");
                }
                UrlBuilder builder = UrlBuilder.ofHttp((String)httpRequest.getUri());
                endPointInfo = EndPointInfoCache.get(builder.getPathStr(), RequestMethod.POST);
                if (Objects.isNull(endPointInfo)) {
                    throw new SnailJobClientException(" Cannot find corresponding processing, please check if the corresponding package is correctly introduced.path:[{}] requestMethod:[{}]", (Object)builder.getPathStr());
                }
                Class<?>[] paramTypes = endPointInfo.getMethod().getParameterTypes();
                SnailJobGrpcRequest snailJobGrpcRequest = request.getSnailJobRequest();
                Object[] args = (Object[])JsonUtil.parseObject((String)snailJobGrpcRequest.getBody(), Object[].class);
                Object[] deSerialize = (Object[])this.deSerialize(JsonUtil.toJsonString((Object)args), endPointInfo.getMethod(), httpRequest, httpResponse);
                for (HandlerInterceptor handlerInterceptor : handlerInterceptors) {
                    if (handlerInterceptor.preHandle(httpRequest, httpResponse, endPointInfo)) continue;
                    snailJobRpcResult = snailJobRpcResult2;
                    break block19;
                }
                resultObj = paramTypes.length > 0 ? (Result)ReflectionUtils.invokeMethod((Method)endPointInfo.getMethod(), (Object)endPointInfo.getExecutor(), (Object[])deSerialize) : (Result)ReflectionUtils.invokeMethod((Method)endPointInfo.getMethod(), (Object)endPointInfo.getExecutor());
                for (HandlerInterceptor handlerInterceptor : handlerInterceptors) {
                    handlerInterceptor.postHandle(httpRequest, httpResponse, endPointInfo);
                }
            }
            catch (Throwable ex) {
                try {
                    SnailJobLog.LOCAL.error("http request error. [{}]", new Object[]{snailJobRequest, ex});
                    snailJobRpcResult2.setMessage(ex.getMessage()).setStatus(StatusEnum.NO.getStatus().intValue());
                    e = ex;
                }
                catch (Throwable throwable) {
                    snailJobRpcResult2.setReqId(0L);
                    if (Objects.nonNull(resultObj)) {
                        snailJobRpcResult2.setData(resultObj.getData()).setMessage(resultObj.getMessage()).setStatus(resultObj.getStatus());
                    }
                    Iterator<HandlerInterceptor> iterator = handlerInterceptors.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw throwable;
                        }
                        HandlerInterceptor handlerInterceptor = iterator.next();
                        handlerInterceptor.afterCompletion(httpRequest, httpResponse, endPointInfo, e);
                    }
                }
                snailJobRpcResult2.setReqId(0L);
                if (Objects.nonNull(resultObj)) {
                    snailJobRpcResult2.setData(resultObj.getData()).setMessage(resultObj.getMessage()).setStatus(resultObj.getStatus());
                }
                for (HandlerInterceptor handlerInterceptor : handlerInterceptors) {
                    handlerInterceptor.afterCompletion(httpRequest, httpResponse, endPointInfo, e);
                }
                return snailJobRpcResult2;
            }
            snailJobRpcResult2.setReqId(0L);
            if (Objects.nonNull(resultObj)) {
                snailJobRpcResult2.setData(resultObj.getData()).setMessage(resultObj.getMessage()).setStatus(resultObj.getStatus());
            }
            for (HandlerInterceptor handlerInterceptor : handlerInterceptors) {
                handlerInterceptor.afterCompletion(httpRequest, httpResponse, endPointInfo, e);
            }
            return snailJobRpcResult2;
        }
        snailJobRpcResult2.setReqId(0L);
        if (Objects.nonNull(resultObj)) {
            snailJobRpcResult2.setData(resultObj.getData()).setMessage(resultObj.getMessage()).setStatus(resultObj.getStatus());
        }
        Iterator<HandlerInterceptor> iterator = handlerInterceptors.iterator();
        while (iterator.hasNext()) {
            HandlerInterceptor handlerInterceptor = iterator.next();
            handlerInterceptor.afterCompletion(httpRequest, httpResponse, endPointInfo, e);
        }
        return snailJobRpcResult;
    }

    private static List<HandlerInterceptor> handlerInterceptors() {
        List handlerInterceptors = ServiceLoaderUtil.loadList(HandlerInterceptor.class);
        if (CollUtil.isEmpty((Collection)handlerInterceptors)) {
            return Collections.emptyList();
        }
        return handlerInterceptors.stream().sorted(Comparator.comparingInt(HandlerInterceptor::order)).collect(Collectors.toList());
    }

    public Object deSerialize(String infoStr, Method method, HttpRequest httpRequest, HttpResponse httpResponse) throws JsonProcessingException {
        Type[] paramTypes = method.getGenericParameterTypes();
        Parameter[] parameters = method.getParameters();
        Object[] params = new Object[paramTypes.length];
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = JsonUtil.toJson((String)infoStr);
        if (Objects.isNull(jsonNode)) {
            SnailJobLog.LOCAL.warn("jsonNode is null. infoStr:[{}]", new Object[]{infoStr});
            return params;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            JsonNode node = jsonNode.get(i);
            if (Objects.nonNull(node)) {
                params[i] = mapper.readValue(node.toString(), mapper.constructType(paramTypes[i]));
                continue;
            }
            Parameter parameter = parameters[i];
            if (parameter.getType().isAssignableFrom(HttpRequest.class)) {
                params[i] = httpRequest;
                continue;
            }
            if (!parameter.getType().isAssignableFrom(HttpResponse.class)) continue;
            params[i] = httpResponse;
        }
        return params;
    }

    @Generated
    public SnailDispatcherRequestHandler(SnailJobProperties snailJobProperties) {
        this.snailJobProperties = snailJobProperties;
    }
}

