/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.alarm.strategy;

import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.attribute.EmailAttribute;
import com.aizuda.snailjob.common.core.alarm.email.MailAccount;
import com.aizuda.snailjob.common.core.alarm.email.MailProperties;
import com.aizuda.snailjob.common.core.alarm.strategy.AbstractAlarm;
import com.aizuda.snailjob.common.core.enums.AlarmTypeEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.MailUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class EmailAlarm
extends AbstractAlarm<AlarmContext> {
    private final MailProperties mailProperties;
    private MailAccount mailAccount;

    @Override
    public Integer getAlarmType() {
        return AlarmTypeEnum.EMAIL.getValue();
    }

    @Override
    public boolean syncSendMessage(AlarmContext alarmContext) {
        if (Objects.isNull(this.mailAccount)) {
            SnailJobLog.LOCAL.warn("\u8bf7\u68c0\u67e5\u90ae\u4ef6\u914d\u7f6e\u662f\u5426\u5f00\u542f", new Object[0]);
            return false;
        }
        try {
            String notifyAttribute = alarmContext.getNotifyAttribute();
            EmailAttribute emailAttribute = JsonUtil.parseObject(notifyAttribute, EmailAttribute.class);
            String text = alarmContext.getText();
            text = text.replaceAll("\n", "<br/>");
            MailUtils.send(this.mailAccount, emailAttribute.getTos(), alarmContext.getTitle(), text, true, new File[0]);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("\u53d1\u9001email\u6d88\u606f\u5931\u8d25:", new Object[]{e});
            return false;
        }
        return true;
    }

    @Override
    public boolean asyncSendMessage(List<AlarmContext> alarmContexts) {
        for (AlarmContext alarmContext : alarmContexts) {
            this.asyncSendMessage(alarmContext);
        }
        return Boolean.TRUE;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Boolean enabled = this.mailProperties.getEnabled();
        if (Objects.isNull(enabled) || Boolean.FALSE.equals(enabled)) {
            return;
        }
        this.mailAccount = this.initMailAccount(this.mailProperties);
        MailUtils.setMailAccount(this.mailAccount);
    }

    private MailAccount initMailAccount(MailProperties mailProperties) {
        MailAccount account = new MailAccount();
        account.setHost(mailProperties.getHost());
        account.setPort(mailProperties.getPort());
        account.setAuth(Optional.ofNullable(mailProperties.getAuth()).orElse(Boolean.FALSE));
        account.setFrom(mailProperties.getFrom());
        account.setUser(mailProperties.getUser());
        account.setPass(mailProperties.getPass());
        account.setSocketFactoryPort(Optional.ofNullable(mailProperties.getPort()).orElse(465));
        account.setStarttlsEnable(Optional.ofNullable(mailProperties.getStarttlsEnable()).orElse(Boolean.FALSE));
        account.setSslEnable(Optional.ofNullable(mailProperties.getSslEnable()).orElse(Boolean.FALSE));
        account.setTimeout(Optional.ofNullable(mailProperties.getTimeout()).orElse(0L));
        account.setConnectionTimeout(Optional.ofNullable(mailProperties.getConnectionTimeout()).orElse(0L));
        return account;
    }

    public EmailAlarm(MailProperties mailProperties) {
        this.mailProperties = mailProperties;
    }
}

