/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.alarm.strategy;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.attribute.QiYeWechatAttribute;
import com.aizuda.snailjob.common.core.alarm.strategy.AbstractAlarm;
import com.aizuda.snailjob.common.core.enums.AlarmTypeEnum;
import com.aizuda.snailjob.common.core.util.DingDingUtils;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class QiYeWechatAlarm
extends AbstractAlarm<AlarmContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QiYeWechatAlarm.class);
    public static final String AT_LABEL = "<@{0}>";

    @Override
    public Integer getAlarmType() {
        return AlarmTypeEnum.WE_COM.getValue();
    }

    @Override
    public boolean syncSendMessage(AlarmContext context) {
        try {
            QiYeWechatAttribute qiYeWechatAttribute = JsonUtil.parseObject(context.getNotifyAttribute(), QiYeWechatAttribute.class);
            String webhookUrl = qiYeWechatAttribute.getWebhookUrl();
            if (StrUtil.isBlank((CharSequence)webhookUrl)) {
                log.error("Please configure the WeChat robot webhookUrl first");
                return false;
            }
            HashMap map = MapUtil.newHashMap();
            QiYeWechatMessageContent messageContent = new QiYeWechatMessageContent();
            messageContent.setContent(StrUtil.sub((CharSequence)DingDingUtils.getAtText(qiYeWechatAttribute.getAts(), context.getText(), AT_LABEL), (int)0, (int)4096));
            map.put("msgtype", "markdown");
            map.put("markdown", messageContent);
            HttpRequest post = HttpUtil.createPost((String)webhookUrl);
            HttpRequest request = post.body(JsonUtil.toJsonString(map), ContentType.JSON.toString());
            HttpResponse execute = request.execute();
            SnailJobLog.LOCAL.debug(JsonUtil.toJsonString(execute), new Object[0]);
            if (execute.isOk()) {
                return true;
            }
            SnailJobLog.LOCAL.error("Sending Enterprise WeChat message failed: {}", new Object[]{execute.body()});
            return false;
        }
        catch (Exception e) {
            log.error("Sending Enterprise WeChat message failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean asyncSendMessage(List<AlarmContext> alarmContexts) {
        for (AlarmContext alarmContext : alarmContexts) {
            this.asyncSendMessage(alarmContext);
        }
        return Boolean.TRUE;
    }

    private static class QiYeWechatMessageContent {
        private String content;

        @Generated
        public QiYeWechatMessageContent() {
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public void setContent(String content) {
            this.content = content;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QiYeWechatMessageContent)) {
                return false;
            }
            QiYeWechatMessageContent other = (QiYeWechatMessageContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QiYeWechatMessageContent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "QiYeWechatAlarm.QiYeWechatMessageContent(content=" + this.getContent() + ")";
        }
    }
}

