/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.executor.job;

import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.dto.ExecuteResult;
import com.aizuda.snailjob.model.request.DispatchJobRequest;
import com.aizuda.snailjob.server.common.dto.InstanceKey;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.dto.JobLogMetaDTO;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.common.rpc.client.SnailJobRetryListener;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.client.JobRpcClient;
import com.aizuda.snailjob.server.job.task.dto.JobExecutorResultDTO;
import com.aizuda.snailjob.server.job.task.dto.JobTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.job.task.dto.RealJobExecutorDTO;
import com.aizuda.snailjob.server.job.task.support.ClientCallbackHandler;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.alarm.event.JobTaskFailAlarmEvent;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackContext;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackFactory;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.google.common.collect.Maps;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="RealJobExecutorActor")
@Scope(value="prototype")
public class RequestClientActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestClientActor.class);
    private final InstanceManager instanceManager;
    private final JobTaskMapper jobTaskMapper;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RealJobExecutorDTO.class, realJobExecutorDTO -> {
            try {
                this.doExecute((RealJobExecutorDTO)realJobExecutorDTO);
            }
            catch (Exception e) {
                log.error("Client request exception occurred", (Throwable)e);
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private void doExecute(RealJobExecutorDTO realJobExecutorDTO) {
        long nowMilli = DateUtils.toNowMilli();
        InstanceLiveInfo instanceLiveInfo = this.instanceManager.getInstanceALiveInfoSet(InstanceKey.builder().namespaceId(realJobExecutorDTO.getNamespaceId()).groupName(realJobExecutorDTO.getGroupName()).hostId(realJobExecutorDTO.getClientId()).build());
        if (Objects.isNull(instanceLiveInfo)) {
            RequestClientActor.taskExecuteFailure(realJobExecutorDTO, "Client does not exist");
            JobLogMetaDTO jobLogMetaDTO = JobTaskConverter.INSTANCE.toJobLogDTO(realJobExecutorDTO);
            jobLogMetaDTO.setTimestamp(Long.valueOf(nowMilli));
            if (realJobExecutorDTO.getRetryStatus().booleanValue()) {
                SnailJobLog.REMOTE.error("Task ID:[{}] Task scheduling failed, executing retry. Reason: No executable client. Retry count:[{}]. <|>{}<|>", new Object[]{realJobExecutorDTO.getTaskId(), realJobExecutorDTO.getRetryCount(), jobLogMetaDTO});
            } else {
                SnailJobLog.REMOTE.error("Task ID:[{}] Task scheduling failed. Reason: No executable client <|>{}<|>", new Object[]{realJobExecutorDTO.getTaskId(), jobLogMetaDTO});
            }
            return;
        }
        DispatchJobRequest dispatchJobRequest = JobTaskConverter.INSTANCE.toDispatchJobRequest(realJobExecutorDTO);
        dispatchJobRequest.setRetry(realJobExecutorDTO.getRetryStatus().booleanValue());
        try {
            JobRpcClient rpcClient = this.buildRpcClient(instanceLiveInfo, realJobExecutorDTO);
            Result<Boolean> dispatch = rpcClient.dispatch(dispatchJobRequest);
            if (dispatch.getStatus() == StatusEnum.YES.getStatus().intValue() && Objects.equals(dispatch.getData(), Boolean.TRUE)) {
                SnailJobLog.LOCAL.info("Task ID:[{}] Task scheduled successfully.", new Object[]{realJobExecutorDTO.getTaskId()});
            } else {
                ClientCallbackHandler clientCallback = ClientCallbackFactory.getClientCallback(realJobExecutorDTO.getTaskType());
                ClientCallbackContext context = JobTaskConverter.INSTANCE.toClientCallbackContext(realJobExecutorDTO);
                context.setTaskStatus(JobTaskStatusEnum.FAIL.getStatus());
                context.setExecuteResult(ExecuteResult.failure(null, (String)dispatch.getMessage()));
                clientCallback.callback(context);
            }
        }
        catch (Exception e) {
            Throwable throwable;
            if (e.getClass().isAssignableFrom(RetryException.class)) {
                re = (RetryException)e;
                throwable = re.getLastFailedAttempt().getExceptionCause();
            } else if (e.getClass().isAssignableFrom(UndeclaredThrowableException.class)) {
                re = (UndeclaredThrowableException)e;
                throwable = ((UndeclaredThrowableException)re).getUndeclaredThrowable();
            } else {
                throwable = e;
            }
            JobLogMetaDTO jobLogMetaDTO = JobTaskConverter.INSTANCE.toJobLogDTO(realJobExecutorDTO);
            jobLogMetaDTO.setTimestamp(Long.valueOf(nowMilli));
            if (realJobExecutorDTO.getRetryStatus().booleanValue()) {
                SnailJobLog.REMOTE.error("Task ID:[{}] Task scheduling failed, executing retry. Retry count:[{}]. <|>{}<|>", new Object[]{jobLogMetaDTO.getTaskId(), realJobExecutorDTO.getRetryCount(), jobLogMetaDTO, throwable});
            } else {
                SnailJobLog.REMOTE.error("Task ID:[{}] Task scheduling failed. <|>{}<|>", new Object[]{jobLogMetaDTO.getTaskId(), jobLogMetaDTO, throwable});
            }
            RequestClientActor.taskExecuteFailure(realJobExecutorDTO, throwable.getMessage());
            SnailSpringContext.getContext().publishEvent((ApplicationEvent)new JobTaskFailAlarmEvent(JobTaskFailAlarmEventDTO.builder().jobTaskBatchId(dispatchJobRequest.getTaskBatchId()).reason(throwable.getMessage()).notifyScene(JobNotifySceneEnum.JOB_TASK_ERROR.getNotifyScene()).build()));
        }
    }

    private JobRpcClient buildRpcClient(InstanceLiveInfo registerNodeInfo, RealJobExecutorDTO realJobExecutorDTO) {
        int maxRetryTimes = realJobExecutorDTO.getMaxRetryTimes();
        boolean retry = realJobExecutorDTO.getRetryStatus();
        return (JobRpcClient)RequestBuilder.newBuilder().nodeInfo(registerNodeInfo).failover(true).allocKey(String.valueOf(realJobExecutorDTO.getJobId())).routeKey(realJobExecutorDTO.getRouteKey().intValue()).failRetry(maxRetryTimes > 0 && !retry).retryTimes(maxRetryTimes).retryInterval(realJobExecutorDTO.getRetryInterval().intValue()).retryListener((SnailJobRetryListener)new JobExecutorRetryListener(realJobExecutorDTO, this.jobTaskMapper)).client(JobRpcClient.class).targetLabels(realJobExecutorDTO.getLabels()).build();
    }

    private static void taskExecuteFailure(RealJobExecutorDTO realJobExecutorDTO, String message) {
        ActorRef actorRef = ActorGenerator.jobTaskExecutorResultActor();
        JobExecutorResultDTO jobExecutorResultDTO = JobTaskConverter.INSTANCE.toJobExecutorResultDTO(realJobExecutorDTO);
        jobExecutorResultDTO.setTaskStatus(JobTaskStatusEnum.FAIL.getStatus());
        jobExecutorResultDTO.setMessage(message);
        actorRef.tell((Object)jobExecutorResultDTO, actorRef);
    }

    @Generated
    public RequestClientActor(InstanceManager instanceManager, JobTaskMapper jobTaskMapper) {
        this.instanceManager = instanceManager;
        this.jobTaskMapper = jobTaskMapper;
    }

    public static class JobExecutorRetryListener
    implements SnailJobRetryListener {
        private final Map<String, Object> properties;
        private final RealJobExecutorDTO realJobExecutorDTO;
        private final JobTaskMapper jobTaskMapper;

        public JobExecutorRetryListener(RealJobExecutorDTO realJobExecutorDTO, JobTaskMapper jobTaskMapper) {
            this.jobTaskMapper = jobTaskMapper;
            this.realJobExecutorDTO = realJobExecutorDTO;
            this.properties = Maps.newHashMap();
        }

        public Map<String, Object> properties() {
            return this.properties;
        }

        public <V> void onRetry(Attempt<V> attempt) {
            Map<String, Object> properties;
            InstanceLiveInfo instanceLiveInfo;
            if (attempt.hasException()) {
                JobLogMetaDTO jobLogMetaDTO = JobTaskConverter.INSTANCE.toJobLogDTO(this.realJobExecutorDTO);
                jobLogMetaDTO.setTimestamp(Long.valueOf(DateUtils.toNowMilli()));
                SnailJobLog.REMOTE.error("Task scheduling failed attempt retry. Task instance ID:[{}] retryCount:[{}]. <|>{}<|>", new Object[]{this.realJobExecutorDTO.getTaskBatchId(), attempt.getAttemptNumber(), jobLogMetaDTO, attempt.getExceptionCause()});
                return;
            }
            if (attempt.hasResult() && attempt.getAttemptNumber() > 1L && Objects.nonNull(instanceLiveInfo = (InstanceLiveInfo)(properties = this.properties()).get("newInstanceLiveInfo"))) {
                RegisterNodeInfo nodeInfo = instanceLiveInfo.getNodeInfo();
                JobTask task = new JobTask();
                task.setClientInfo(ClientInfoUtils.generate((RegisterNodeInfo)nodeInfo));
                task.setId(this.realJobExecutorDTO.getTaskId());
                task.setRetryCount(Integer.valueOf((int)attempt.getAttemptNumber()));
                this.jobTaskMapper.updateById((Object)task);
            }
        }
    }
}

