/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.generator.task;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.JobArgsTypeEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.JobArgsHolder;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.generator.task.AbstractJobTaskGenerator;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGenerateContext;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class ShardingTaskGenerator
extends AbstractJobTaskGenerator {
    private static final String TASK_NAME = "SHARDING_TASK";
    private final InstanceManager instanceManager;

    @Override
    public JobTaskTypeEnum getTaskInstanceType() {
        return JobTaskTypeEnum.SHARDING;
    }

    @Override
    public List<JobTask> doGenerate(JobTaskGenerateContext context) {
        List argsStrs;
        Set liveInfoSet = this.instanceManager.getInstanceALiveInfoSet(context.getNamespaceId(), context.getGroupName(), context.getLabels());
        if (CollUtil.isEmpty((Collection)liveInfoSet)) {
            SnailJobLog.LOCAL.error("No executable client information. Job ID:[{}]", new Object[]{context.getJobId()});
            return Lists.newArrayList();
        }
        String argsStr = context.getArgsStr();
        if (StrUtil.isBlank((CharSequence)argsStr)) {
            SnailJobLog.LOCAL.error("Slice parameters are empty. Job ID:[{}]", new Object[]{context.getJobId()});
            return Lists.newArrayList();
        }
        try {
            argsStrs = JsonUtil.parseList((String)argsStr, String.class);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Slice parameter parsing failed. Job ID:[{}]", new Object[]{context.getJobId(), e});
            return Lists.newArrayList();
        }
        ArrayList nodeInfoList = new ArrayList(liveInfoSet);
        ArrayList<JobTask> jobTasks = new ArrayList<JobTask>(argsStrs.size());
        for (int index = 0; index < argsStrs.size(); ++index) {
            InstanceLiveInfo liveInfo = (InstanceLiveInfo)nodeInfoList.get(index % liveInfoSet.size());
            JobTask jobTask = JobTaskConverter.INSTANCE.toJobTaskInstance(context);
            jobTask.setClientInfo(ClientInfoUtils.generate((RegisterNodeInfo)liveInfo.getNodeInfo()));
            JobArgsHolder jobArgsHolder = new JobArgsHolder();
            jobArgsHolder.setJobParams(argsStrs.get(index));
            jobTask.setArgsStr(JsonUtil.toJsonString((Object)jobArgsHolder));
            jobTask.setArgsType(JobArgsTypeEnum.JSON.getArgsType());
            jobTask.setTaskStatus(Integer.valueOf(JobTaskStatusEnum.RUNNING.getStatus()));
            jobTask.setResultMessage(Optional.ofNullable(jobTask.getResultMessage()).orElse(""));
            jobTask.setParentId(Long.valueOf(0L));
            jobTask.setRetryCount(Integer.valueOf(0));
            jobTask.setLeaf(StatusEnum.YES.getStatus());
            jobTask.setCreateDt(LocalDateTime.now());
            jobTask.setUpdateDt(LocalDateTime.now());
            jobTask.setTaskName(TASK_NAME);
            jobTasks.add(jobTask);
        }
        this.batchSaveJobTasks(jobTasks);
        return jobTasks;
    }

    @Generated
    public ShardingTaskGenerator(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }
}

