/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.alibaba.middleware.tls;

import com.alibaba.ans.shaded.com.alibaba.middleware.tls.SelfTrustManager;
import com.alibaba.ans.shaded.com.alibaba.middleware.tls.util.TlsUtil;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class JavaSSLSocketFactory {
    private static SSLSocketFactory javaSsf;

    public static SSLSocketFactory createJavaSSLSocketFactory(Boolean clientAuth, String trustCertPath) throws SSLException {
        if (javaSsf != null) {
            return javaSsf;
        }
        return JavaSSLSocketFactory.createJavaSSLSocketFactory0(clientAuth, trustCertPath);
    }

    private static synchronized SSLSocketFactory createJavaSSLSocketFactory0(Boolean clientAuth, String trustCertPath) throws SSLException {
        if (javaSsf != null) {
            return javaSsf;
        }
        try {
            SSLSocketFactory sf;
            clientAuth = clientAuth != null ? clientAuth : TlsUtil.serverNeedClientAuth();
            trustCertPath = trustCertPath != null ? trustCertPath : TlsUtil.clientTrustCertPath();
            TrustManager[] trustManagers = SelfTrustManager.trustManager(clientAuth, trustCertPath);
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, trustManagers, new SecureRandom());
            javaSsf = sf = sc.getSocketFactory();
        }
        catch (Exception e) {
            throw new SSLException("Https createJavaSSLSocketFactory error ", e);
        }
        return javaSsf;
    }
}

