/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.core;

import com.alibaba.ans.shaded.com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Host;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.TenantInfo;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class Domain {
    @JSONField(serialize=false)
    private String jsonFromServer = "";
    public static final String SPLITER = "@@";
    @JSONField(name="dom")
    private String name;
    private String clusters;
    private long cacheMillis = 1000L;
    private List<Host> hosts = new ArrayList<Host>();
    private long lastRefTime = 0L;
    private String checksum = "";
    @JSONField(serialize=false)
    private String specifiedURL = "";
    private Boolean useSpecifiedURL = false;
    private String env = "";
    @JSONField(serialize=false)
    private boolean trafficScheduling;
    private volatile boolean allIPs = false;
    private List<Host> hostsFromSpecifiedURL = new ArrayList<Host>();

    public Domain() {
    }

    public boolean isAllIPs() {
        return this.allIPs;
    }

    public void setAllIPs(boolean allIPs) {
        this.allIPs = allIPs;
    }

    public Domain(String key) {
        String[] keys = key.split(SPLITER);
        if (keys.length >= 4) {
            this.name = keys[0];
            this.clusters = keys[1];
            this.env = keys[2];
            if (StringUtils.equals(keys[3], "000--00-ALL_IPS--00--000")) {
                this.setAllIPs(true);
            }
        } else if (keys.length >= 3) {
            this.name = keys[0];
            this.clusters = keys[1];
            if (StringUtils.equals(keys[2], "000--00-ALL_IPS--00--000")) {
                this.setAllIPs(true);
            } else {
                this.env = keys[2];
            }
        } else if (keys.length >= 2) {
            this.name = keys[0];
            if (StringUtils.equals(keys[1], "000--00-ALL_IPS--00--000")) {
                this.setAllIPs(true);
            } else {
                this.clusters = keys[1];
            }
        }
        this.name = keys[0];
    }

    public Boolean getUseSpecifiedURL() {
        return this.useSpecifiedURL;
    }

    public void setUseSpecifiedURL(Boolean useSpecifiedURL) {
        this.useSpecifiedURL = useSpecifiedURL;
    }

    public Domain(String name, String clusters) {
        this(name, clusters, "");
    }

    public Domain(String name, String clusters, String env) {
        this.name = name;
        this.clusters = clusters;
        this.env = env;
    }

    public List<Host> getHostsFromSpecifiedURL() {
        return this.hostsFromSpecifiedURL;
    }

    public void setHostsFromSpecifiedURL(List<Host> hostsFromSpecifiedURL) {
        this.hostsFromSpecifiedURL = hostsFromSpecifiedURL;
    }

    public int ipCount() {
        return this.hosts.size();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.lastRefTime > this.cacheMillis;
    }

    public String getSpecifiedURL() {
        return this.specifiedURL;
    }

    public void setSpecifiedURL(String specifiedURL) {
        this.specifiedURL = specifiedURL;
    }

    public Boolean getIsUseSpecifiedURL() {
        return this.useSpecifiedURL;
    }

    public void setIsUseSpecifiedURL(Boolean useSpecifiedURL) {
        this.useSpecifiedURL = useSpecifiedURL;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setHosts(List<Host> hosts) {
        this.hosts = hosts;
    }

    public boolean isValid() {
        return this.hosts != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastRefTime(long lastRefTime) {
        this.lastRefTime = lastRefTime;
    }

    public long getLastRefTime() {
        return this.lastRefTime;
    }

    public String getClusters() {
        return this.clusters;
    }

    public void setClusters(String clusters) {
        this.clusters = clusters;
    }

    public long getCacheMillis() {
        return this.cacheMillis;
    }

    public void setCacheMillis(long cacheMillis) {
        this.cacheMillis = cacheMillis;
    }

    public List<Host> getHosts() {
        return new ArrayList<Host>(this.hosts);
    }

    public void setTrafficScheduling(boolean trafficScheduling) {
        this.trafficScheduling = trafficScheduling;
    }

    public boolean isTrafficScheduling() {
        return this.trafficScheduling;
    }

    public boolean validate() {
        if (this.isAllIPs()) {
            return true;
        }
        if (CollectionUtils.isEmpty(this.hosts)) {
            return false;
        }
        ArrayList<Host> validHosts = new ArrayList<Host>();
        for (Host host : this.hosts) {
            if (!host.isValid()) continue;
            int i = 0;
            while ((double)i < host.getDoubleWeight()) {
                validHosts.add(host);
                ++i;
            }
        }
        return !CollectionUtils.isEmpty(validHosts);
    }

    @JSONField(serialize=false)
    public String getJsonFromServer() {
        return this.jsonFromServer;
    }

    public void setJsonFromServer(String jsonFromServer) {
        this.jsonFromServer = jsonFromServer;
    }

    @JSONField(serialize=false)
    public String getKey() {
        return Domain.getKey(this.name, this.clusters, this.env, this.isAllIPs());
    }

    @JSONField(serialize=false)
    public static String getKey(String name, String clusters, String unit) {
        return Domain.getKey(name, clusters, unit, false);
    }

    @JSONField(serialize=false)
    public static String getKey(String name, String clusters, String unit, boolean isAllIPs) {
        if (StringUtils.isNotEmpty(TenantInfo.tenantEnv) && StringUtils.isEmpty(unit)) {
            unit = TenantInfo.tenantEnv;
        }
        if (StringUtils.isEmpty(unit)) {
            unit = "";
        }
        if (!StringUtils.isEmpty(clusters) && !StringUtils.isEmpty(unit)) {
            return isAllIPs ? name + SPLITER + clusters + SPLITER + unit + SPLITER + "000--00-ALL_IPS--00--000" : name + SPLITER + clusters + SPLITER + unit;
        }
        if (!StringUtils.isEmpty(clusters)) {
            return isAllIPs ? name + SPLITER + clusters + SPLITER + "000--00-ALL_IPS--00--000" : name + SPLITER + clusters;
        }
        if (!StringUtils.isEmpty(unit)) {
            return isAllIPs ? name + SPLITER + "" + SPLITER + unit + SPLITER + "000--00-ALL_IPS--00--000" : name + SPLITER + "" + SPLITER + unit;
        }
        return isAllIPs ? name + SPLITER + "000--00-ALL_IPS--00--000" : name;
    }

    public String toString() {
        return this.getKey();
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }
}

