/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.core;

import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MotionFlow {
    private static ConcurrentMap<String, Flow> flows = new ConcurrentHashMap<String, Flow>();

    public static void enter(String dom) {
        try {
            Flow flow = (Flow)flows.get(dom);
            if (flow == null) {
                flows.putIfAbsent(dom, new Flow());
                return;
            }
            if (System.currentTimeMillis() - flow.time > 1000L) {
                flow.time = System.currentTimeMillis();
                flow.old = flow.cur;
                flow.cur = 1L;
            } else {
                flow.cur++;
            }
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "error while entering motion flow for dom: " + dom);
        }
    }

    public static long view(String dom) {
        try {
            Flow flow = (Flow)flows.get(dom);
            if (flow == null) {
                return 0L;
            }
            return flow.old;
        }
        catch (Exception e) {
            VIPClient.LOG.error("NA", "error while viewing motion flow for dom: " + dom);
            return 0L;
        }
    }

    private static class Flow {
        private long cur = 1L;
        private long old = 1L;
        private long time = System.currentTimeMillis();

        private Flow() {
        }
    }
}

