/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.actuate.endpoint;

import com.alibaba.boot.dubbo.actuate.endpoint.AbstractDubboEndpoint;
import com.alibaba.dubbo.config.AbstractConfig;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ConsumerConfig;
import com.alibaba.dubbo.config.MethodConfig;
import com.alibaba.dubbo.config.ModuleConfig;
import com.alibaba.dubbo.config.MonitorConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.ServiceConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="dubbo-configs")
public class DubboConfigsMetadataEndpoint
extends AbstractDubboEndpoint {
    @ReadOperation
    public Map<String, Map<String, Map<String, Object>>> configs() {
        LinkedHashMap<String, Map<String, Map<String, Object>>> configsMap = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
        this.addDubboConfigBeans(ApplicationConfig.class, configsMap);
        this.addDubboConfigBeans(ConsumerConfig.class, configsMap);
        this.addDubboConfigBeans(MethodConfig.class, configsMap);
        this.addDubboConfigBeans(ModuleConfig.class, configsMap);
        this.addDubboConfigBeans(MonitorConfig.class, configsMap);
        this.addDubboConfigBeans(ProtocolConfig.class, configsMap);
        this.addDubboConfigBeans(ProviderConfig.class, configsMap);
        this.addDubboConfigBeans(ReferenceConfig.class, configsMap);
        this.addDubboConfigBeans(RegistryConfig.class, configsMap);
        this.addDubboConfigBeans(ServiceConfig.class, configsMap);
        return configsMap;
    }

    private void addDubboConfigBeans(Class<? extends AbstractConfig> dubboConfigClass, Map<String, Map<String, Map<String, Object>>> configsMap) {
        Map dubboConfigBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, dubboConfigClass);
        String name = dubboConfigClass.getSimpleName();
        TreeMap<String, Map<String, Object>> beansMetadata = new TreeMap<String, Map<String, Object>>();
        for (Map.Entry entry : dubboConfigBeans.entrySet()) {
            String beanName = (String)entry.getKey();
            AbstractConfig configBean = (AbstractConfig)entry.getValue();
            Map<String, Object> configBeanMeta = this.resolveBeanMetadata(configBean);
            beansMetadata.put(beanName, configBeanMeta);
        }
        configsMap.put(name, beansMetadata);
    }
}

