/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.actuate.health;

import com.alibaba.boot.dubbo.actuate.health.DubboHealthIndicatorProperties;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.status.Status;
import com.alibaba.dubbo.common.status.StatusChecker;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.StringUtils;

public class DubboHealthIndicator
extends AbstractHealthIndicator {
    @Autowired
    private DubboHealthIndicatorProperties dubboHealthIndicatorProperties;
    @Autowired(required=false)
    private Map<String, ProtocolConfig> protocolConfigs = Collections.emptyMap();
    @Autowired(required=false)
    private Map<String, ProviderConfig> providerConfigs = Collections.emptyMap();

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(StatusChecker.class);
        Map<String, String> statusCheckerNamesMap = this.resolveStatusCheckerNamesMap();
        boolean hasError = false;
        boolean hasUnknown = false;
        builder.up();
        for (Map.Entry<String, String> entry : statusCheckerNamesMap.entrySet()) {
            String statusCheckerName = entry.getKey();
            String source = entry.getValue();
            StatusChecker checker = (StatusChecker)extensionLoader.getExtension(statusCheckerName);
            Status status = checker.check();
            Status.Level level = status.getLevel();
            if (!hasError && level.equals((Object)Status.Level.ERROR)) {
                hasError = true;
                builder.down();
            }
            if (!hasError && !hasUnknown && level.equals((Object)Status.Level.UNKNOWN)) {
                hasUnknown = true;
                builder.unknown();
            }
            LinkedHashMap<String, String> detail = new LinkedHashMap<String, String>();
            detail.put("source", source);
            detail.put("status", (String)status);
            builder.withDetail(statusCheckerName, detail);
        }
    }

    protected Map<String, String> resolveStatusCheckerNamesMap() {
        LinkedHashMap<String, String> statusCheckerNamesMap = new LinkedHashMap<String, String>();
        statusCheckerNamesMap.putAll(this.resolveStatusCheckerNamesMapFromDubboHealthIndicatorProperties());
        statusCheckerNamesMap.putAll(this.resolveStatusCheckerNamesMapFromProtocolConfigs());
        statusCheckerNamesMap.putAll(this.resolveStatusCheckerNamesMapFromProviderConfig());
        return statusCheckerNamesMap;
    }

    private Map<String, String> resolveStatusCheckerNamesMapFromDubboHealthIndicatorProperties() {
        DubboHealthIndicatorProperties.Status status = this.dubboHealthIndicatorProperties.getStatus();
        LinkedHashMap<String, String> statusCheckerNamesMap = new LinkedHashMap<String, String>();
        for (String statusName : status.getDefaults()) {
            statusCheckerNamesMap.put(statusName, "management.health.dubbo.status.defaults");
        }
        for (String statusName : status.getExtras()) {
            statusCheckerNamesMap.put(statusName, "management.health.dubbo.status.extras");
        }
        return statusCheckerNamesMap;
    }

    private Map<String, String> resolveStatusCheckerNamesMapFromProtocolConfigs() {
        LinkedHashMap<String, String> statusCheckerNamesMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, ProtocolConfig> entry : this.protocolConfigs.entrySet()) {
            String beanName = entry.getKey();
            ProtocolConfig protocolConfig = entry.getValue();
            Set<String> statusCheckerNames = this.getStatusCheckerNames(protocolConfig);
            for (String statusCheckerName : statusCheckerNames) {
                String source = this.buildSource(beanName, protocolConfig);
                statusCheckerNamesMap.put(statusCheckerName, source);
            }
        }
        return statusCheckerNamesMap;
    }

    private Map<String, String> resolveStatusCheckerNamesMapFromProviderConfig() {
        LinkedHashMap<String, String> statusCheckerNamesMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, ProviderConfig> entry : this.providerConfigs.entrySet()) {
            String beanName = entry.getKey();
            ProviderConfig providerConfig = entry.getValue();
            Set<String> statusCheckerNames = this.getStatusCheckerNames(providerConfig);
            for (String statusCheckerName : statusCheckerNames) {
                String source = this.buildSource(beanName, providerConfig);
                statusCheckerNamesMap.put(statusCheckerName, source);
            }
        }
        return statusCheckerNamesMap;
    }

    private Set<String> getStatusCheckerNames(ProtocolConfig protocolConfig) {
        String status = protocolConfig.getStatus();
        return StringUtils.commaDelimitedListToSet((String)status);
    }

    private Set<String> getStatusCheckerNames(ProviderConfig providerConfig) {
        String status = providerConfig.getStatus();
        return StringUtils.commaDelimitedListToSet((String)status);
    }

    private String buildSource(String beanName, Object bean) {
        return beanName + "@" + bean.getClass().getSimpleName() + ".getStatus()";
    }
}

