/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.autoconfigure;

import com.alibaba.boot.dubbo.autoconfigure.RelaxedDubboConfigBinder;
import com.alibaba.dubbo.config.AbstractConfig;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.ServiceAnnotationBeanPostProcessor;
import com.alibaba.dubbo.config.spring.context.annotation.EnableDubboConfig;
import java.util.Collections;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@Configuration
@ConditionalOnProperty(prefix="dubbo", name={"enabled"}, matchIfMissing=true, havingValue="true")
@ConditionalOnClass(value={AbstractConfig.class})
public class DubboAutoConfiguration {
    @ConditionalOnProperty(name={"dubbo.scan.basePackages"})
    @ConditionalOnClass(value={RelaxedPropertyResolver.class})
    @Bean
    public ServiceAnnotationBeanPostProcessor serviceAnnotationBeanPostProcessor(Environment environment) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment);
        Set packagesToScan = (Set)resolver.getProperty("dubbo.scan.basePackages", Set.class, Collections.emptySet());
        return new ServiceAnnotationBeanPostProcessor(packagesToScan);
    }

    @ConditionalOnClass(value={RelaxedDataBinder.class})
    @Bean
    @Scope(scopeName="prototype")
    public RelaxedDubboConfigBinder relaxedDubboConfigBinder() {
        return new RelaxedDubboConfigBinder();
    }

    @ConditionalOnMissingBean
    @Bean(name={"referenceAnnotationBeanPostProcessor"})
    public ReferenceAnnotationBeanPostProcessor referenceAnnotationBeanPostProcessor() {
        return new ReferenceAnnotationBeanPostProcessor();
    }

    @ConditionalOnProperty(name={"dubbo.config.multiple"}, havingValue="true")
    @EnableDubboConfig(multiple=true)
    protected static class MultipleDubboConfigConfiguration {
        protected MultipleDubboConfigConfiguration() {
        }
    }

    @EnableDubboConfig
    protected static class SingleDubboConfigConfiguration {
        protected SingleDubboConfigConfiguration() {
        }
    }
}

