/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.context.event;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class AwaitingNonWebApplicationListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(AwaitingNonWebApplicationListener.class);
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static final AtomicBoolean shutdownHookRegistered = new AtomicBoolean(false);
    private static final AtomicBoolean awaited = new AtomicBoolean(false);

    public void onApplicationEvent(ApplicationReadyEvent event) {
        final SpringApplication springApplication = event.getSpringApplication();
        if (springApplication.isWebEnvironment()) {
            return;
        }
        executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SpringApplication springApplication2 = springApplication;
                synchronized (springApplication2) {
                    if (logger.isInfoEnabled()) {
                        logger.info(" [Dubbo] Current Spring Boot Application is await...");
                    }
                    while (!awaited.get()) {
                        try {
                            springApplication.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
        });
        if (shutdownHookRegistered.compareAndSet(false, true)) {
            this.registerShutdownHook(new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SpringApplication springApplication2 = springApplication;
                    synchronized (springApplication2) {
                        if (awaited.compareAndSet(false, true)) {
                            springApplication.notifyAll();
                            if (logger.isInfoEnabled()) {
                                logger.info(" [Dubbo] Current Spring Boot Application is about to shutdown...");
                            }
                            executorService.shutdown();
                        }
                    }
                }
            }));
        }
    }

    private void registerShutdownHook(Thread thread) {
        Runtime.getRuntime().addShutdownHook(thread);
    }
}

