/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.velocity;

import com.alibaba.boot.velocity.util.PathUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.velocity.VelocityProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.velocity.VelocityLayoutViewResolver;

@ConfigurationProperties(prefix="spring.velocity")
public class VelocityLayoutProperties
extends VelocityProperties {
    private boolean layoutEnabled = true;
    private String layoutUrl = "layout.vm";
    private String layoutKey = "layout";
    private String screenContentKey = "screen_content";

    public boolean isLayoutEnabled() {
        return this.layoutEnabled;
    }

    public void setLayoutEnabled(boolean layoutEnabled) {
        this.layoutEnabled = layoutEnabled;
    }

    public String getLayoutUrl() {
        return this.layoutUrl;
    }

    public void setLayoutUrl(String layoutUrl) {
        this.layoutUrl = layoutUrl;
    }

    public String getLayoutKey() {
        return this.layoutKey;
    }

    public void setLayoutKey(String layoutKey) {
        this.layoutKey = layoutKey;
    }

    public String getScreenContentKey() {
        return this.screenContentKey;
    }

    public void setScreenContentKey(String screenContentKey) {
        this.screenContentKey = screenContentKey;
    }

    @Override
    public void applyToViewResolver(Object viewResolver) {
        super.applyToViewResolver(viewResolver);
        Assert.isInstanceOf(VelocityLayoutViewResolver.class, (Object)viewResolver, (String)("ViewResolver is not an instance of VelocityLayoutViewResolver : " + viewResolver));
        BeanUtils.copyProperties((Object)((Object)this), (Object)viewResolver);
    }

    @Override
    public void setResourceLoaderPath(String resourceLoaderPath) {
        String normalizedPath = PathUtils.normalize(resourceLoaderPath);
        super.setResourceLoaderPath(normalizedPath);
    }

    public void setPrefix(String prefix) {
        String actualPrefix = PathUtils.removeHeadSlash(prefix);
        if (!actualPrefix.endsWith("/")) {
            actualPrefix = actualPrefix + "/";
        }
        super.setPrefix(actualPrefix);
    }
}

