/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.expand;

import com.alibaba.antx.expand.Expander;
import com.alibaba.antx.expand.ExpanderException;
import com.alibaba.antx.expand.ExpanderRuntime;
import com.alibaba.antx.util.CharsetUtil;
import com.alibaba.antx.util.StringUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class ExpanderRuntimeImpl
implements ExpanderRuntime {
    private final BufferedReader in;
    private final PrintWriter out;
    private final PrintWriter err;
    private final String charset;
    private boolean verbose;
    private final Expander expander;

    public ExpanderRuntimeImpl() {
        this(System.in, System.out, System.err, null);
    }

    public ExpanderRuntimeImpl(InputStream inputStream, OutputStream outStream, OutputStream errStream, String charset) {
        boolean charsetSpecified = !StringUtil.isEmpty(charset);
        this.charset = charsetSpecified ? charset : CharsetUtil.detectedSystemCharset();
        try {
            this.in = new BufferedReader(new InputStreamReader(inputStream, this.charset));
            this.out = new PrintWriter((Writer)new OutputStreamWriter(outStream, this.charset), true);
            this.err = new PrintWriter((Writer)new OutputStreamWriter(errStream, this.charset), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new ExpanderException(e);
        }
        if (!charsetSpecified) {
            this.out.println("Detected system charset encoding: " + this.charset);
            this.out.println("If your can't read the following text, specify correct one like this: ");
            this.out.println("  autoexpand -c mycharset");
            this.out.println();
        }
        this.expander = new Expander(this);
    }

    public BufferedReader getIn() {
        return this.in;
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public PrintWriter getErr() {
        return this.err;
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Expander getExpander() {
        return this.expander;
    }

    public void setVerbose() {
        this.verbose = true;
    }

    public void debug(String message) {
        if (this.verbose) {
            this.getOut().println(message);
        }
    }

    public void info(String message) {
        this.getOut().println(message);
    }

    public void warn(String message) {
        this.getOut().println(message);
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(Throwable cause) {
        this.error(null, cause);
    }

    public void error(String message, Throwable cause) {
        if (StringUtil.isBlank(message) && cause != null) {
            message = "ERROR: " + cause.getMessage();
        }
        this.getErr().println(message);
        if (this.verbose) {
            cause.printStackTrace(this.getErr());
            this.getErr().println();
        }
    }

    public void start() {
        this.expander.expand();
    }
}

