/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.expand.cli;

import com.alibaba.antx.expand.ExpanderException;
import com.alibaba.antx.expand.ExpanderRuntime;
import com.alibaba.antx.expand.ExpanderRuntimeImpl;
import com.alibaba.antx.expand.cli.CLIException;
import com.alibaba.antx.expand.cli.CLIManager;
import com.alibaba.antx.util.Profiler;
import com.alibaba.antx.util.cli.CommandLine;
import com.alibaba.citrus.logconfig.LogConfigurator;
import java.text.MessageFormat;

public class Main {
    private static CommandLine cli;
    private static ExpanderRuntime runtime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Profiler.start("Starting antxexpand");
        Main.initLogging(false, null);
        int returnCode = 0;
        try {
            returnCode = Main.run(args);
        }
        catch (CLIException e) {
            System.err.println(e.getMessage());
            System.exit(returnCode);
        }
        finally {
            Profiler.release();
        }
        runtime.info("");
        runtime.info(Main.getDuration("\u603b\u8017\u8d39\u65f6\u95f4\uff1a{0,choice,0#|.1#{0,number,integer}\u5206}{1,choice,0#|.1#{1,number,integer}\u79d2}{2,number,integer}\u6beb\u79d2", Profiler.getEntry().getDuration()));
        runtime.info("");
        System.exit(returnCode);
    }

    private static String getDuration(String message, long duration) {
        long ms = duration % 1000L;
        long secs = duration / 1000L % 60L;
        long min = duration / 1000L / 60L;
        return MessageFormat.format(message, new Long(min), new Long(secs), new Long(ms));
    }

    private static void initLogging(boolean verbose, String charset) {
        LogConfigurator.getConfigurator().configureDefault(verbose, charset);
    }

    private static int run(String[] args) {
        CLIManager manager = new CLIManager();
        if (args.length == 0) {
            args = new String[]{"-h"};
        }
        cli = manager.parse(args);
        String charset = cli.getOptionValue("c");
        ExpanderRuntimeImpl runtimeImpl = new ExpanderRuntimeImpl(System.in, System.out, System.err, charset);
        runtime = runtimeImpl;
        if (cli.hasOption("h")) {
            manager.help(runtimeImpl.getOut());
            return 0;
        }
        if (cli.hasOption("v")) {
            runtimeImpl.setVerbose();
            Main.initLogging(true, charset);
        } else {
            Main.initLogging(false, charset);
        }
        if (cli.hasOption("w")) {
            runtimeImpl.getExpander().setExpandWar(Main.getBooleanValue("w"));
        }
        if (cli.hasOption("r")) {
            runtimeImpl.getExpander().setExpandRar(Main.getBooleanValue("r"));
        }
        if (cli.hasOption("e")) {
            runtimeImpl.getExpander().setExpandEjbjar(Main.getBooleanValue("e"));
        }
        if (cli.hasOption("o")) {
            runtimeImpl.getExpander().setOverwrite(Main.getBooleanValue("o"));
        }
        if (cli.hasOption("k")) {
            runtimeImpl.getExpander().setKeepRedundantFiles(Main.getBooleanValue("k"));
        }
        if ((args = cli.getArgs()).length >= 1) {
            runtimeImpl.getExpander().setSrcfile(args[0]);
        }
        if (args.length >= 2) {
            runtimeImpl.getExpander().setDestdir(args[1]);
        }
        try {
            runtimeImpl.start();
        }
        catch (Exception e) {
            runtimeImpl.error(e);
        }
        return 0;
    }

    private static boolean getBooleanValue(String key) {
        String value = cli.getOptionValue(key);
        if (value == null) {
            value = "yes";
        }
        if (value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("no")) {
            return false;
        }
        throw new ExpanderException("invalid value of -" + key + ": " + value + ", should be yes or no");
    }
}

