/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.util.cli;

import com.alibaba.antx.util.cli.Option;
import com.alibaba.antx.util.cli.OptionGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Options {
    private Map shortOpts = new HashMap();
    private Map longOpts = new HashMap();
    private List requiredOpts = new ArrayList();
    private Map optionGroups = new HashMap();

    public Options addOptionGroup(OptionGroup group) {
        Iterator options = group.getOptions().iterator();
        if (group.isRequired()) {
            this.requiredOpts.add(group);
        }
        while (options.hasNext()) {
            Option option = (Option)options.next();
            option.setRequired(false);
            this.addOption(option);
            this.optionGroups.put(option.getOpt(), group);
        }
        return this;
    }

    public Options addOption(String opt, boolean hasArg, String description) {
        this.addOption(opt, null, hasArg, description);
        return this;
    }

    public Options addOption(String opt, String longOpt, boolean hasArg, String description) {
        this.addOption(new Option(opt, longOpt, hasArg, description));
        return this;
    }

    public Options addOption(Option opt) {
        String shortOpt = "-" + opt.getOpt();
        if (opt.hasLongOpt()) {
            this.longOpts.put("--" + opt.getLongOpt(), opt);
        }
        if (opt.isRequired()) {
            this.requiredOpts.add(shortOpt);
        }
        this.shortOpts.put(shortOpt, opt);
        return this;
    }

    public Collection getOptions() {
        ArrayList opts = new ArrayList(this.shortOpts.values());
        for (Object item : this.longOpts.values()) {
            if (opts.contains(item)) continue;
            opts.add(item);
        }
        return Collections.unmodifiableCollection(opts);
    }

    List helpOptions() {
        return new ArrayList(this.shortOpts.values());
    }

    public List getRequiredOptions() {
        return this.requiredOpts;
    }

    public Option getOption(String opt) {
        Option option = null;
        option = opt.length() == 1 ? (Option)this.shortOpts.get("-" + opt) : (opt.startsWith("--") ? (Option)this.longOpts.get(opt) : (Option)this.shortOpts.get(opt));
        return option == null ? null : (Option)option.clone();
    }

    public boolean hasOption(String opt) {
        if (opt.length() == 1) {
            return this.shortOpts.containsKey("-" + opt);
        }
        if (opt.startsWith("--")) {
            return this.longOpts.containsKey(opt);
        }
        return this.shortOpts.containsKey(opt);
    }

    public OptionGroup getOptionGroup(Option opt) {
        return (OptionGroup)this.optionGroups.get(opt.getOpt());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ Options: [ short ");
        buf.append(this.shortOpts.toString());
        buf.append(" ] [ long ");
        buf.append(this.longOpts);
        buf.append(" ]");
        return buf.toString();
    }
}

