/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util;

import com.alibaba.toolkit.util.collection.ArrayHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;

public class ContextClassLoader {
    private static Method GET_CONTEXT_CLASS_LOADER_METHOD = null;

    public static URL[] getResources(String resourceName) {
        Object classLoader = null;
        ArrayHashSet urlSet = new ArrayHashSet();
        boolean found = false;
        found = ContextClassLoader.getResources(urlSet, resourceName, ContextClassLoader.getClassLoader(), false);
        if (!found) {
            ContextClassLoader.getResources(urlSet, resourceName, ContextClassLoader.class.getClassLoader(), false);
        }
        if (!found) {
            ContextClassLoader.getResources(urlSet, resourceName, null, true);
        }
        if (found) {
            return urlSet.toArray(new URL[urlSet.size()]);
        }
        return new URL[0];
    }

    private static boolean getResources(Set urlSet, String resourceName, ClassLoader classLoader, boolean sysClassLoader) {
        Enumeration<URL> i = null;
        try {
            if (classLoader != null) {
                i = classLoader.getResources(resourceName);
            } else if (sysClassLoader) {
                i = ClassLoader.getSystemResources(resourceName);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (i != null && i.hasMoreElements()) {
            while (i.hasMoreElements()) {
                urlSet.add(i.nextElement());
            }
            return true;
        }
        return false;
    }

    public static URL getResource(String resourceName) {
        ClassLoader classLoader = null;
        URL url = null;
        classLoader = ContextClassLoader.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resourceName)) != null) {
            return url;
        }
        classLoader = ContextClassLoader.class.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resourceName)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(resourceName);
    }

    public static InputStream getResourceAsStream(String resourceName) {
        URL url = ContextClassLoader.getResource(resourceName);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return ContextClassLoader.loadClass(className, true, null);
    }

    public static Class loadClass(String className, boolean initialize, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            classLoader = ContextClassLoader.getClassLoader();
        }
        return Class.forName(className, initialize, classLoader);
    }

    public static ClassLoader getClassLoader() {
        if (GET_CONTEXT_CLASS_LOADER_METHOD != null) {
            try {
                return (ClassLoader)GET_CONTEXT_CLASS_LOADER_METHOD.invoke((Object)Thread.currentThread(), (Object[])null);
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    static {
        try {
            GET_CONTEXT_CLASS_LOADER_METHOD = Thread.class.getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

