/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.collection;

import com.alibaba.toolkit.util.collection.ArrayHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ArrayHashSet
extends AbstractSet
implements Set,
Cloneable,
Serializable {
    private static final Object PRESENT = new Object();
    protected transient ArrayHashMap map;
    private static final long serialVersionUID = -5024744406713321676L;

    public ArrayHashSet() {
        this.map = new ArrayHashMap();
    }

    public ArrayHashSet(int initialCapacity) {
        this.map = new ArrayHashMap(initialCapacity);
    }

    public ArrayHashSet(int initialCapacity, float loadFactor) {
        this.map = new ArrayHashMap(initialCapacity, loadFactor);
    }

    public ArrayHashSet(Collection collection) {
        this.map = new ArrayHashMap(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        this.addAll(collection);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    public boolean add(Object object) {
        return this.map.put(object, PRESENT) == null;
    }

    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    public void clear() {
        this.map.clear();
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public Object clone() {
        try {
            ArrayHashSet newSet = (ArrayHashSet)super.clone();
            newSet.map = (ArrayHashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private synchronized void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        int capacity = is.readInt();
        float loadFactor = is.readFloat();
        this.map = new ArrayHashMap(capacity, loadFactor);
        int size = is.readInt();
        for (int i = 0; i < size; ++i) {
            Object e = is.readObject();
            this.map.put(e, PRESENT);
        }
    }

    private synchronized void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
        os.writeInt(this.map.getCapacity());
        os.writeFloat(this.map.getLoadFactor());
        os.writeInt(this.map.size());
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            os.writeObject(i.next());
        }
    }
}

