/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.toolkit.util.enumeration;

import com.alibaba.toolkit.util.enumeration.Enum;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class BigIntegerEnum
extends Enum {
    static final long serialVersionUID = 3407019802348379119L;

    protected BigIntegerEnum(String name) {
        super(name);
    }

    protected BigIntegerEnum(String name, int value) {
        super(name, new BigInteger(String.valueOf(value)));
    }

    protected BigIntegerEnum(String name, long value) {
        super(name, new BigInteger(String.valueOf(value)));
    }

    protected BigIntegerEnum(String name, String value) {
        super(name, new BigInteger(value));
    }

    protected BigIntegerEnum(String name, BigInteger value) {
        super(name, value);
    }

    protected BigIntegerEnum(String name, BigDecimal value) {
        super(name, value.toBigInteger());
    }

    protected static Object createEnumType() {
        return new Enum.EnumType(){

            protected Class getUnderlyingClass() {
                return BigInteger.class;
            }

            protected Object getNextValue(Object value, boolean flagMode) {
                if (value == null) {
                    return flagMode ? BigInteger.ONE : BigInteger.ZERO;
                }
                if (flagMode) {
                    return ((BigInteger)value).shiftLeft(1);
                }
                return ((BigInteger)value).add(BigInteger.ONE);
            }

            protected boolean isZero(Object value) {
                return ((BigInteger)value).equals(BigInteger.ZERO);
            }

            protected boolean isPowerOfTwo(Object value) {
                BigInteger bintValue = (BigInteger)value;
                int bitIndex = bintValue.getLowestSetBit();
                if (bitIndex < 0) {
                    return false;
                }
                return bintValue.clearBit(bitIndex).equals(BigInteger.ZERO);
            }
        };
    }

    public int intValue() {
        return ((BigInteger)this.getValue()).intValue();
    }

    public long longValue() {
        return ((BigInteger)this.getValue()).longValue();
    }

    public double doubleValue() {
        return ((BigInteger)this.getValue()).doubleValue();
    }

    public float floatValue() {
        return ((BigInteger)this.getValue()).floatValue();
    }

    public String toHexString() {
        return ((BigInteger)this.getValue()).toString(16);
    }

    public String toOctalString() {
        return ((BigInteger)this.getValue()).toString(8);
    }

    public String toBinaryString() {
        return ((BigInteger)this.getValue()).toString(2);
    }
}

