/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.redis;

import com.alibaba.cloud.ai.memory.redis.serializer.MessageDeserializer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.memory.ChatMemoryRepository;
import org.springframework.ai.chat.messages.Message;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisChatMemoryRepository
implements ChatMemoryRepository,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(RedisChatMemoryRepository.class);
    private static final String DEFAULT_KEY_PREFIX = "spring_ai_alibaba_chat_memory:";
    private final JedisPool jedisPool;
    private final ObjectMapper objectMapper;

    private RedisChatMemoryRepository(JedisPool jedisPool) {
        Assert.notNull((Object)jedisPool, (String)"jedisPool cannot be null");
        this.jedisPool = jedisPool;
        this.objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Message.class, (JsonDeserializer)new MessageDeserializer());
        this.objectMapper.registerModule((Module)module);
    }

    public static RedisBuilder builder() {
        return new RedisBuilder();
    }

    public List<String> findConversationIds() {
        try (Jedis jedis = this.jedisPool.getResource();){
            ArrayList keys = new ArrayList(jedis.keys("spring_ai_alibaba_chat_memory:*"));
            List<String> list = keys.stream().map(key -> key.substring(DEFAULT_KEY_PREFIX.length())).toList();
            return list;
        }
    }

    public List<Message> findByConversationId(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = DEFAULT_KEY_PREFIX + conversationId;
            List messageStrings = jedis.lrange(key, 0L, -1L);
            ArrayList<Message> messages = new ArrayList<Message>();
            for (String messageString : messageStrings) {
                try {
                    Message message = (Message)this.objectMapper.readValue(messageString, Message.class);
                    messages.add(message);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Error deserializing message", e);
                }
            }
            ArrayList<Message> arrayList = messages;
            return arrayList;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveAll(String conversationId, List<Message> messages) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        Assert.notNull(messages, (String)"messages cannot be null");
        Assert.noNullElements(messages, (String)"messages cannot contain null elements");
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = DEFAULT_KEY_PREFIX + conversationId;
            this.deleteByConversationId(conversationId);
            for (Message message : messages) {
                try {
                    String messageJson = this.objectMapper.writeValueAsString((Object)message);
                    jedis.rpush(key, new String[]{messageJson});
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Error serializing message", e);
                    return;
                }
            }
        }
    }

    public void deleteByConversationId(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = DEFAULT_KEY_PREFIX + conversationId;
            jedis.del(key);
        }
    }

    public void clearOverLimit(String conversationId, int maxLimit, int deleteSize) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = DEFAULT_KEY_PREFIX + conversationId;
            List all = jedis.lrange(key, 0L, -1L);
            if (all.size() >= maxLimit) {
                all = all.stream().skip(Math.max(0, deleteSize)).toList();
                this.deleteByConversationId(conversationId);
                for (String message : all) {
                    jedis.rpush(key, new String[]{message});
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.jedisPool != null) {
            this.jedisPool.close();
            logger.info("Redis connection pool closed");
        }
    }

    public static class RedisBuilder {
        private String host = "127.0.0.1";
        private int port = 6379;
        private String password;
        private int timeout = 2000;
        private JedisPoolConfig poolConfig;

        public RedisBuilder host(String host) {
            this.host = host;
            return this;
        }

        public RedisBuilder port(int port) {
            this.port = port;
            return this;
        }

        public RedisBuilder password(String password) {
            this.password = password;
            return this;
        }

        public RedisBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public RedisBuilder poolConfig(JedisPoolConfig poolConfig) {
            this.poolConfig = poolConfig;
            return this;
        }

        public RedisChatMemoryRepository build() {
            if (this.poolConfig == null) {
                this.poolConfig = new JedisPoolConfig();
            }
            JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)this.poolConfig, this.host, this.port, this.timeout, this.password);
            return new RedisChatMemoryRepository(jedisPool);
        }
    }
}

