/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.context;

/**
 * 阿里云的云产品通用配置。
 *
 * @author xiaolongzuo
 */
public interface AliCloudConfiguration {

    /**
     * 获取账号AccessKey
     *
     * @return AccessKey
     */
    String getAccessKey();

    /**
     * 获取账号SecretKey
     *
     * @return SecretKey
     */
    String getSecretKey();

}
